/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import processing.core.PApplet;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuIO {
    PApplet app;
    Object[] actionObjects;
    ClassLoader cl;
    protected ArrayList<String> menuPackages = new ArrayList();

    public MenuIO() {
        String string = Menu.class.getPackage().getName();
        this.menuPackages.add(string);
    }

    public ArrayList<MenuItem> loadFromXML(Reader reader, PApplet pApplet, Object ... objectArray) {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        this.app = pApplet;
        this.cl = pApplet.getClass().getClassLoader();
        this.actionObjects = objectArray;
        Stack<XMLElement> stack = new Stack<XMLElement>();
        try {
            XMLElement xMLElement = new XMLElement(reader);
            stack.push(xMLElement);
            while (!stack.isEmpty()) {
                XMLElement xMLElement2 = (XMLElement)stack.pop();
                if (xMLElement2.getName().equalsIgnoreCase("menu")) {
                    arrayList.add(this.processElement(null, xMLElement2));
                    continue;
                }
                Enumeration enumeration = xMLElement2.enumerateChildren();
                while (enumeration.hasMoreElements()) {
                    stack.push((XMLElement)enumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public MenuItem processElement(MenuItem menuItem, XMLElement xMLElement) {
        Object object;
        Object object2;
        MenuItem menuItem2 = null;
        String string = xMLElement.getName();
        String string2 = xMLElement.getStringAttribute("name");
        xMLElement.removeAttribute("name");
        if (xMLElement.hasAttribute("type")) {
            object2 = xMLElement.getStringAttribute("type");
            xMLElement.removeAttribute("type");
            menuItem2 = this.createMenu((String)object2);
            if (string2 != null) {
                menuItem2.setName(string2);
            } else {
                menuItem2.setName("");
            }
        }
        if (menuItem == null && !string.equalsIgnoreCase("menu")) {
            throw new RuntimeException("[MenuIO] XML menu parsing error on " + string + " element: <item> requires a parent <menu> or <item>!");
        }
        if (string.equalsIgnoreCase("item") || string.equalsIgnoreCase("menu")) {
            if (menuItem2 != null && menuItem != null) {
                menuItem2 = menuItem.add(menuItem2);
            } else if (menuItem != null) {
                menuItem2 = menuItem.add(string2);
            }
        } else if (string.equalsIgnoreCase("methodcall")) {
            object2 = xMLElement.getStringAttribute("method");
            object = xMLElement.getStringAttribute("param");
            xMLElement.removeAttribute("method");
            xMLElement.removeAttribute("param");
            try {
                Method method = menuItem.getClass().getMethod((String)object2, String.class);
                method.invoke((Object)menuItem, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = xMLElement.enumerateAttributeNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            this.setAttribute(menuItem2, (String)object, xMLElement.getStringAttribute((String)object));
        }
        object = xMLElement.getChildren();
        for (int i = 0; i < ((XMLElement[])object).length; ++i) {
            XMLElement xMLElement2 = object[i];
            this.processElement(menuItem2, xMLElement2);
        }
        return menuItem2;
    }

    protected MenuItem createMenu(String string) {
        Constructor<?> constructor;
        Object object;
        Class<?> clazz = null;
        if (string.indexOf(46) != -1) {
            try {
                clazz = this.cl.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            for (String string2 : this.menuPackages) {
                object = string2 + "." + string;
                try {
                    clazz = this.cl.loadClass((String)object);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            String string2;
            constructor = clazz.getConstructor(PApplet.class);
            string2 = constructor.newInstance(this.app);
            return (MenuItem)((Object)string2);
        }
        catch (Exception exception) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
                object = constructor.newInstance(new Object[0]);
                return (MenuItem)object;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                return null;
            }
        }
    }

    protected void setAttribute(MenuItem menuItem, String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = "set" + MenuIO.upperFirst(string);
        if (string3.matches("(action|property|methodcall|condition)")) {
            this.setWithObjectRef(menuItem, string, string2);
            return;
        }
        Class<?> clazz = menuItem.getClass();
        try {
            Method method = clazz.getMethod(string4, String.class);
            method.invoke((Object)menuItem, string2);
        }
        catch (Exception exception) {
            try {
                Method method = clazz.getMethod(string4, Float.TYPE);
                method.invoke((Object)menuItem, Float.valueOf(Float.parseFloat(string2)));
            }
            catch (Exception exception2) {
                try {
                    Method method = clazz.getMethod(string4, Boolean.TYPE);
                    method.invoke((Object)menuItem, Boolean.parseBoolean(string2));
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
    }

    protected void setWithObjectRef(MenuItem menuItem, String string, String string2) {
        String string3 = "set" + MenuIO.upperFirst(string);
        Class<?> clazz = menuItem.getClass();
        try {
            Method method = clazz.getMethod(string3, Object.class, String.class);
            for (Object object : this.actionObjects) {
                try {
                    method.invoke((Object)menuItem, object, string2);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String upperFirst(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1, string.length());
        return string2 + string3;
    }
}

