/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIEvent;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.ifaces.UIListener;
import org.andrewberman.ui.ifaces.UIObject;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.tween.PropertyTween;
import org.andrewberman.ui.tween.TweenFriction;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;

public abstract class Menu
extends MenuItem
implements UIObject {
    public static final int CLICKAWAY_COLLAPSES = 1;
    public static final int CLICKAWAY_HIDES = 0;
    public static final int CLICKAWAY_IGNORED = 2;
    static final int PAD = 10;
    public static final int START_SIZE = 50;
    protected boolean actionOnMouseDown;
    public float alpha = 1.0f;
    protected PropertyTween aTween;
    protected boolean autoDim;
    protected PGraphicsJava2D buff;
    Rectangle2D.Float buffRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    protected PApplet canvas;
    protected int clickAwayBehavior;
    protected boolean clickToggles;
    public boolean consumeEvents;
    protected int cursor;
    public float dimAlpha = 0.3f;
    public boolean focusOnShow;
    public float fullAlpha = 1.0f;
    protected MenuItem hovered;
    protected MenuItem lastPressed;
    protected MenuItem kbFocus;
    protected boolean hoverNavigable;
    protected ArrayList listeners = new ArrayList(1);
    public boolean modalFocus;
    Point mousePt = new Point(0.0f, 0.0f);
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    Composite origComp;
    RenderingHints origRH;
    Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    protected boolean singletNavigation;
    public boolean useCameraCoordinates;
    protected boolean useHandCursor;
    protected boolean usesJava2D;

    public Menu(PApplet pApplet) {
        this.canvas = pApplet;
        this.setMenu(this);
        this.setOptions();
        this.init();
        UIGlobals.g.event().add(this);
    }

    public void dispose() {
        if (UIGlobals.g != null && UIGlobals.g.event() != null) {
            UIGlobals.g.event().remove(this);
        }
        super.dispose();
    }

    public void addListener(UIListener uIListener) {
        this.listeners.add(uIListener);
    }

    protected void clickaway() {
        switch (this.clickAwayBehavior) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.closeMyChildren();
                break;
            }
        }
    }

    public void close() {
        this.close(this);
        UIUtils.releaseCursor(this, this.canvas);
        if (this.modalFocus) {
            UIGlobals.g.focus().removeFromFocus(this);
        } else if (this.focusOnShow) {
            UIGlobals.g.focus().removeFromFocus(this);
        }
        this.fireEvent(4);
    }

    public void close(MenuItem menuItem) {
        ArrayList<MenuItem> arrayList = menuItem.items;
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuItem menuItem2 = arrayList.get(i);
            this.close(menuItem2);
            menuItem2.setState(0);
        }
        menuItem.isOpen = false;
    }

    protected boolean containsPoint(Point point) {
        return false;
    }

    public abstract MenuItem create(String var1);

    protected void createBuffer(int n, int n2) {
        this.buff = (PGraphicsJava2D)this.canvas.createGraphics(n, n2, "processing.core.PGraphicsJava2D");
    }

    public synchronized void draw() {
        if (this.hidden) {
            return;
        }
        this.aTween.update();
        if (!this.isRootMenu()) {
            this.hint();
            super.draw();
            this.unhint();
            return;
        }
        if (UIUtils.isJava2D(this.canvas)) {
            this.canvas.pushMatrix();
            this.resetMatrix(this.canvas.g);
            this.hint();
            super.draw();
            this.unhint();
            this.canvas.popMatrix();
        } else if (!this.usesJava2D) {
            this.canvas.pushMatrix();
            this.resetMatrix(this.canvas.g);
            super.draw();
            this.canvas.popMatrix();
        } else {
            this.resizeBuffer();
            this.hint();
            this.buff.beginDraw();
            this.buff.background(this.menu.getStyle().getC("c.background").getRGB(), 0.0f);
            this.buff.translate(-this.x, -this.y);
            this.buff.translate(-this.offsetX, -this.offsetY);
            super.draw();
            this.buff.setModified(true);
            this.buff.endDraw();
            this.drawToCanvas();
            this.unhint();
        }
    }

    protected void drawToCanvas() {
        int n = (int)(this.rect.width + 20.0f);
        int n2 = (int)(this.rect.height + 20.0f);
        this.canvas.pushMatrix();
        this.resetMatrix(this.canvas.g);
        this.canvas.image((PImage)this.buff, this.x + this.offsetX, this.y + this.offsetY, (float)n, (float)n2, 0, 0, n, n2);
        this.canvas.popMatrix();
    }

    public void fireEvent(int n) {
        UIEvent uIEvent = new UIEvent(this, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UIListener)this.listeners.get(i)).uiEvent(uIEvent);
        }
    }

    public void focusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.close();
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    protected void hint() {
        this.origRH = this.buff.g2.getRenderingHints();
        this.origComp = this.buff.g2.getComposite();
        this.buff.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.buff.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.buff.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.buff.g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
    }

    protected void init() {
        if (UIUtils.isJava2D(this.canvas)) {
            this.buff = (PGraphicsJava2D)this.canvas.g;
        } else if (this.usesJava2D) {
            this.createBuffer(50, 50);
        }
        this.aTween = new PropertyTween(this, "alpha", TweenFriction.tween(0.25f), 1, this.fullAlpha, this.fullAlpha, 15.0f);
    }

    public boolean isRootMenu() {
        return this.menu == this;
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        if (this.hidden) {
            return;
        }
        super.itemMouseEvent(mouseEvent, point);
        if (this.mouseInside && this.consumeEvents) {
            mouseEvent.consume();
        }
        if (this.autoDim) {
            if (this.mouseInside) {
                if (this.aTween != null) {
                    this.aTween.continueTo(this.fullAlpha);
                }
            } else if (this.menu.hovered == null && this.aTween != null) {
                this.aTween.continueTo(this.dimAlpha);
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.close();
            }
        }
        if (this.kbFocus != null) {
            this.kbFocus.keyEvent(keyEvent);
        }
        super.keyEvent(keyEvent);
    }

    public synchronized void layout() {
        super.layout();
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        Point point3 = point2;
        if (this.isRootMenu() && !this.useCameraCoordinates) {
            point3 = point;
        }
        this.mousePt.setLocation(point3);
        this.setCursor(-1);
        this.itemMouseEvent(mouseEvent, this.mousePt);
        if (!this.mouseInside && this.isOpen() && mouseEvent.getID() == 501) {
            this.clickaway();
        }
        if (this.useHandCursor && this.isOpen() && this.cursor == -1) {
            if (this.mouseInside) {
                UIUtils.setCursor(this, this.canvas, 12);
            } else {
                UIUtils.releaseCursor(this, this.canvas);
            }
        }
    }

    public void open() {
        this.open(this);
        if (this.modalFocus) {
            UIGlobals.g.focus().setModalFocus(this);
        } else if (this.focusOnShow) {
            UIGlobals.g.focus().setFocus(this);
        }
        this.fireEvent(3);
    }

    public void open(MenuItem menuItem) {
        if (!menuItem.isEnabled()) {
            return;
        }
        if (menuItem.isOpen()) {
            this.close();
        }
        menuItem.isOpen = true;
    }

    public void removeListener(UIListener uIListener) {
        this.listeners.remove(uIListener);
    }

    protected void resetMatrix(PGraphics pGraphics) {
        if (this.useCameraCoordinates) {
            return;
        }
        UIUtils.resetMatrix(pGraphics);
    }

    protected void resizeBuffer() {
        this.rect.setFrame(this.x, this.y, 0.0, 0.0);
        this.buffRect.setFrame(this.x, this.y, 0.0, 0.0);
        this.getRect(this.rect, this.buffRect);
        float f = 0.0f;
        float f2 = 0.0f;
        f = this.rect.x - (this.x + this.offsetX + 10.0f);
        f2 = this.rect.y - (this.y + this.offsetY + 10.0f);
        this.offsetX += f;
        this.offsetY += f2;
        int n = this.buff.width;
        int n2 = this.buff.height;
        boolean bl = false;
        if (this.rect.width > (float)(this.buff.width - 20)) {
            n = (int)(this.rect.width + 20.0f);
            bl = true;
        }
        if (this.rect.height > (float)(this.buff.height - 20)) {
            n2 = (int)(this.rect.height + 20.0f);
            bl = true;
        }
        if (bl) {
            this.createBuffer(n, n2);
        }
    }

    protected void setCursor(int n) {
        this.cursor = n;
        if (n != -1) {
            UIUtils.setCursor(this, this.canvas, n);
        }
    }

    public void setFontSize(float f) {
        this.getStyle().set("f.fontSize", Float.valueOf(f));
        this.layout();
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (!this.isRootMenu()) {
            UIGlobals.g.event().remove(this);
        }
    }

    public void setOptions() {
        this.useCameraCoordinates = true;
        this.usesJava2D = true;
        this.hoverNavigable = false;
        this.clickToggles = false;
        this.singletNavigation = true;
        this.actionOnMouseDown = false;
        this.clickAwayBehavior = 0;
        this.useHandCursor = true;
        this.autoDim = false;
        this.focusOnShow = false;
        this.modalFocus = false;
        this.consumeEvents = true;
    }

    protected void setParent(MenuItem menuItem) {
        super.setParent(menuItem);
    }

    protected void setState(int n) {
    }

    public void setState(MenuItem menuItem, int n) {
        if (menuItem.menu != this) {
            throw new IllegalArgumentException();
        }
        if (menuItem == this) {
            return;
        }
        if (menuItem.getState() == n) {
            return;
        }
        menuItem.setState(n);
        if (this.hoverNavigable) {
            if (n == 1 || n == 2) {
                timer.setMenuItem(menuItem);
            } else if (n == 0) {
                timer.unsetMenuItem(menuItem);
            }
        }
        if (n == 2) {
            this.lastPressed = menuItem;
            this.hovered = menuItem;
            this.kbFocus = menuItem;
        } else if (n == 1) {
            this.hovered = menuItem;
            this.kbFocus = menuItem;
        } else if (n == 0 && menuItem == this.hovered) {
            this.hovered = null;
        }
    }

    protected void unhint() {
        this.buff.g2.setRenderingHints(this.origRH);
        this.buff.g2.setComposite(this.origComp);
    }
}

