/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenFriction;
import org.andrewberman.ui.tween.TweenListener;
import processing.core.PImage;

public class DockItem
extends MenuItem
implements TweenListener {
    Tween tween = new Tween(this, TweenFriction.tween(0.6f), 1, 0.0f, 0.0f, 6.0f);
    PImage icon;
    String iconFile;

    public void setIcon(String string) {
        this.iconFile = string;
        if (this.menu != null && this.menu.canvas != null) {
            this.icon = this.menu.canvas.loadImage(this.iconFile);
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.icon == null && this.iconFile != null) {
            this.setIcon(this.iconFile);
        }
    }

    public void draw() {
        this.tween.update();
        float f = this.getStyle().getF("f.padX");
        if (this.icon != null) {
            float f2 = f;
            float f3 = this.width - f2 * 2.0f;
            float f4 = this.height - f2 * 2.0f;
            float f5 = f2;
            float f6 = f2;
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (this.icon.width < this.icon.height) {
                f8 = f4;
                f7 = (float)this.icon.width * f8 / (float)this.icon.height;
                f5 = (f3 - f7) / 2.0f + f2;
            } else {
                f7 = f3;
                f8 = (float)this.icon.height * f7 / (float)this.icon.width;
                f6 = (f4 - f8) / 2.0f + f2;
            }
            if (UIUtils.isJava2D(this.menu.canvas)) {
                this.menu.canvas.smooth();
                this.menu.canvas.image(this.icon, this.x + f5, this.y + f6, f7, f8);
                this.menu.canvas.noSmooth();
            } else {
                int n = (int)(this.menu.alpha * 255.0f);
                this.menu.canvas.tint(255, (float)n);
                this.menu.canvas.image(this.icon, this.x + f5, this.y + f6, f7, f8);
                this.menu.canvas.noTint();
            }
        }
        super.draw();
    }

    protected boolean containsPoint(Point point) {
        return !(point.x < this.x || point.x > this.x + this.width || point.y < this.y) && !(point.y > this.y + this.height);
    }

    public void setSize(float f, float f2) {
        this.tween.continueTo(f);
    }

    public void forceSize(float f, float f2) {
        this.setSize(f, f2);
        this.tween.fforward();
        this.tween.update();
    }

    public String getLabel() {
        return this.getName();
    }

    public void tweenEvent(Tween tween, int n) {
        if (tween == this.tween) {
            this.width = this.height = this.tween.getPosition();
        }
    }
}

