/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.DockItem;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;

public class Dock
extends Menu {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    DockRotationHandler rotation;
    RoundRectangle2D.Float drawRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    RoundRectangle2D.Float mouseRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    Point mousePt = new Point(0.0f, 0.0f);
    float origWidth;
    float inset = this.getStyle().getF("f.padX");
    float offset;
    float maxPossibleWidth;
    float curWidth;
    float curHeight;
    float curLow;
    boolean isActivated;
    public float bulgeAmount = 0.7f;
    public float bulgeWidth = 20.0f;
    public boolean autoCenter;
    public boolean triangleOnSelected;
    public boolean consumeWhenActive;

    public Dock(PApplet pApplet) {
        super(pApplet);
        this.rotation = new DockRotationHandler();
        this.rotation.setRotation(3);
        this.setWidth(40.0f);
        this.open();
    }

    public void setOptions() {
        super.setOptions();
        this.useCameraCoordinates = false;
        this.clickAwayBehavior = 1;
        this.hoverNavigable = false;
        this.clickToggles = true;
        this.useHandCursor = true;
        this.actionOnMouseDown = true;
        this.usesJava2D = true;
        this.autoDim = true;
        this.autoCenter = true;
        this.triangleOnSelected = true;
        this.consumeWhenActive = true;
    }

    public synchronized void layout() {
        if (!this.isOpen()) {
            return;
        }
        this.mousePt.setLocation(this.canvas.mouseX, this.canvas.mouseY);
        if (this.useCameraCoordinates) {
            UIUtils.screenToModel(this.mousePt);
        }
        float f = this.mousePos();
        float f2 = this.origWidth * (float)this.items.size();
        float f3 = this.rotation.getCenter();
        float f4 = f3 - f2 / 2.0f;
        float f5 = f - f4;
        float f6 = 0.0f;
        float f7 = f4;
        for (MenuItem menuItem : this.items) {
            float f8 = f7 + this.origWidth / 2.0f;
            float f9 = this.bulge(f8 - f);
            menuItem.setSize(this.origWidth * f9, this.origWidth * f9);
            f6 += menuItem.getHeight();
            f7 += this.origWidth;
        }
        f7 = this.curLow = f4 - (f6 - f2) * (f5 / f2);
        float f10 = 0.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.get(i);
            this.rotation.positionItem(menuItem, f7);
            f7 += menuItem.getHeight();
            if (!(menuItem.getWidth() > f10)) continue;
            f10 = menuItem.getWidth();
        }
        this.curHeight = f7 - this.curLow;
        this.curWidth = f10;
    }

    float mousePos() {
        return this.rotation.getMousePos(this.mousePt);
    }

    float bulge(float f) {
        if (this.isActivated) {
            return 1.0f + this.bulgeAmount * PApplet.exp((float)(-f * f / (this.bulgeWidth * this.bulgeWidth)));
        }
        return 1.0f;
    }

    public void setOffsetFromCenter(float f) {
        this.offset = f;
        this.layout();
    }

    public void setWidth(float f) {
        this.origWidth = f;
        this.maxPossibleWidth = this.origWidth * (1.0f + this.bulgeAmount);
        this.layout();
    }

    public void setInset(float f) {
        this.inset = f;
        this.layout();
    }

    public void setRotation(String string) {
        if (string.equalsIgnoreCase("left")) {
            this.rotation.setRotation(0);
        } else if (string.equalsIgnoreCase("right")) {
            this.rotation.setRotation(1);
        }
        if (string.equalsIgnoreCase("top")) {
            this.rotation.setRotation(2);
        }
        if (string.equalsIgnoreCase("bottom")) {
            this.rotation.setRotation(3);
        }
    }

    public DockItem getSelectedItem() {
        if (this.lastPressed == null) {
            return null;
        }
        return (DockItem)this.lastPressed;
    }

    void resetPosition() {
        for (MenuItem menuItem : this.items) {
            DockItem dockItem = (DockItem)menuItem;
            dockItem.forceSize(this.origWidth, this.origWidth);
        }
        this.layout();
    }

    public synchronized void drawMyself() {
        float f;
        float f2;
        float f3;
        RenderingHints renderingHints;
        Object object;
        this.layout();
        this.rotation.setRect(this.drawRect, this.origWidth);
        Color color = this.getStyle().getC("c.foreground");
        float f4 = this.getStyle().getF("f.strokeWeight");
        BasicStroke basicStroke = new BasicStroke(f4);
        float f5 = this.getStyle().getF("f.padX");
        float f6 = this.getStyle().getF("f.padY");
        PFont pFont = this.getStyle().getFont("font");
        if (this.usesJava2D) {
            object = this.menu.buff.g2;
            ((Graphics2D)object).setPaint(this.getStyle().getGradient(0, 0.0f, (float)this.drawRect.getMinY(), 0.0f, (float)this.drawRect.getMaxY()));
            ((Graphics2D)object).fill(this.drawRect);
            ((Graphics2D)object).setStroke(basicStroke);
            ((Graphics2D)object).setPaint(color);
            renderingHints = ((Graphics2D)object).getRenderingHints();
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)object).draw(this.drawRect);
            ((Graphics2D)object).setRenderingHints(renderingHints);
        } else {
            int n = (int)(this.menu.alpha * 255.0f);
            this.canvas.beginShape(16);
            this.canvas.stroke(this.canvas.color(color.getRGB(), n));
            Color color2 = this.getStyle().getC("c.gradientLo");
            int n2 = this.canvas.color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
            this.canvas.fill(n2);
            this.canvas.vertex((float)this.drawRect.getMinX(), (float)this.drawRect.getMinY());
            this.canvas.vertex((float)this.drawRect.getMaxX(), (float)this.drawRect.getMinY());
            color2 = this.getStyle().getC("c.gradientHi");
            n2 = this.canvas.color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
            this.canvas.fill(n2);
            this.canvas.vertex((float)this.drawRect.getMaxX(), (float)this.drawRect.getMaxY());
            this.canvas.vertex((float)this.drawRect.getMinX(), (float)this.drawRect.getMaxY());
            this.canvas.endShape();
        }
        if (this.hovered != null) {
            object = (DockItem)this.hovered;
            float f7 = this.origWidth / 2.0f;
            float f8 = UIUtils.getTextAscent(this.menu.canvas.g, pFont, f7, false);
            float f9 = UIUtils.getTextDescent(this.menu.canvas.g, pFont, f7, false);
            f3 = f8 + f9;
            f2 = UIUtils.getTextWidth(this.menu.canvas.g, pFont, f7, ((DockItem)object).getLabel(), false);
            f = 0.0f;
            float f10 = 0.0f;
            switch (this.rotation.rot) {
                case 0: {
                    this.menu.canvas.textAlign(37);
                    f = this.inset + this.maxPossibleWidth + f5;
                    f10 = ((MenuItem)object).getY() + ((MenuItem)object).getHeight() / 2.0f + f3 / 2.0f - f9 / 2.0f;
                    break;
                }
                case 1: {
                    this.menu.canvas.textAlign(37);
                    f = (float)this.menu.canvas.width - this.inset - this.maxPossibleWidth - f5 - f2;
                    f10 = ((MenuItem)object).getY() + ((MenuItem)object).getHeight() / 2.0f + f3 / 2.0f - f9 / 2.0f;
                    break;
                }
                case 2: {
                    this.menu.canvas.textAlign(3);
                    f = ((MenuItem)object).getX() + ((MenuItem)object).getWidth() / 2.0f;
                    f10 = this.inset + this.maxPossibleWidth + f5 + f3 - f9;
                    break;
                }
                case 3: {
                    this.menu.canvas.textAlign(3);
                    f = ((MenuItem)object).getX() + ((MenuItem)object).getWidth() / 2.0f;
                    f10 = (float)this.menu.canvas.width - this.inset - this.maxPossibleWidth - f5;
                }
            }
            if (this.usesJava2D) {
                MenuUtils.drawWhiteTextRect(this, f - f5, f10 - f8 - f5, f2 + f5 * 2.0f, f3 + f5 * 2.0f);
            }
            Color color3 = color;
            int n = (int)(this.menu.alpha * 255.0f);
            this.menu.canvas.fill(this.menu.canvas.color(color3.getRed(), color3.getGreen(), color3.getBlue(), n));
            this.menu.canvas.textFont(UIGlobals.g.getPFont());
            this.menu.canvas.textSize(f7);
            this.menu.canvas.text(((DockItem)object).getLabel(), f, f10);
            this.menu.canvas.textAlign(37);
        }
        if (this.lastPressed != null && this.triangleOnSelected) {
            object = this.lastPressed;
            renderingHints = this.canvas.g;
            int n = (int)(this.menu.alpha * 255.0f);
            Color color4 = color;
            renderingHints.fill(this.menu.canvas.color(color4.getRed(), color4.getGreen(), color4.getBlue(), n));
            f3 = ((MenuItem)object).getWidth() / 8.0f;
            switch (this.rotation.rot) {
                case 0: {
                    f2 = ((MenuItem)object).getY() + ((MenuItem)object).getHeight() / 2.0f;
                    f = this.inset + f5;
                    renderingHints.triangle(f, f2 + f3, f, f2 - f3, f + f3, f2);
                    ((MenuItem)object).setPosition(((MenuItem)object).getX() + f3, ((MenuItem)object).getY());
                    break;
                }
                case 1: {
                    f2 = ((MenuItem)object).getY() + ((MenuItem)object).getHeight() / 2.0f;
                    f = (float)this.canvas.width - this.inset - f5;
                    renderingHints.triangle(f, f2 + f3, f, f2 - f3, f - f3, f2);
                    ((MenuItem)object).setPosition(((MenuItem)object).getX() - f3, ((MenuItem)object).getY());
                    break;
                }
                case 2: {
                    f2 = this.inset + f6;
                    f = ((MenuItem)object).getX() + ((MenuItem)object).getWidth() / 2.0f;
                    renderingHints.triangle(f + f3, f2, f - f3, f2, f, f2 + f3);
                    ((MenuItem)object).setPosition(((MenuItem)object).getX(), ((MenuItem)object).getY() + f3);
                    break;
                }
                case 3: {
                    f2 = (float)this.canvas.width - this.inset - f6;
                    f = ((MenuItem)object).getX() + ((MenuItem)object).getWidth() / 2.0f;
                    renderingHints.triangle(f + f3, f2, f - f3, f2, f, f2 - f3);
                    ((MenuItem)object).setPosition(((MenuItem)object).getX(), ((MenuItem)object).getY() - f3);
                }
            }
        }
    }

    public void focusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.isActivated = false;
            this.layout();
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        super.keyEvent(keyEvent);
    }

    public void setState(MenuItem menuItem, int n) {
        super.setState(menuItem, n);
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        if (this.useCameraCoordinates) {
            this.mousePt.setLocation(point2);
        } else {
            this.mousePt.setLocation(point);
        }
        if (mouseEvent.getID() == 503 || mouseEvent.getID() == 506) {
            if (this.containsPoint(this.mousePt)) {
                this.isActivated = true;
                UIGlobals.g.focus().setModalFocus(this);
            } else {
                this.isActivated = false;
                UIGlobals.g.focus().removeFromFocus(this);
            }
        }
        super.mouseEvent(mouseEvent, point, point2);
        if (this.isActivated && this.consumeWhenActive) {
            mouseEvent.consume();
        }
    }

    public boolean containsPoint(Point point) {
        if (this.mouseRect == null || this.rotation == null) {
            return false;
        }
        this.rotation.setRect(this.mouseRect, this.curWidth);
        return this.mouseRect.contains(point);
    }

    public float getX() {
        return 0.0f;
    }

    public float getY() {
        return 0.0f;
    }

    public void setPosition(float f, float f2) {
        this.inset = f;
        this.offset = f2;
        this.layout();
    }

    public MenuItem create(String string) {
        DockItem dockItem = new DockItem();
        dockItem.setName(string);
        return dockItem;
    }

    public DockItem add(String string, String string2) {
        DockItem dockItem = new DockItem();
        dockItem.setName(string);
        dockItem.setIcon(string2);
        this.add(dockItem);
        return dockItem;
    }

    public MenuItem add(MenuItem menuItem) {
        super.add(menuItem);
        this.resetPosition();
        return menuItem;
    }

    public float getBulgeAmount() {
        return this.bulgeAmount;
    }

    public void setBulgeAmount(float f) {
        this.bulgeAmount = f;
    }

    public float getBulgeWidth() {
        return this.bulgeWidth;
    }

    public void setBulgeWidth(float f) {
        this.bulgeWidth = f;
    }

    class DockRotationHandler {
        int rot = 0;

        DockRotationHandler() {
        }

        void setRotation(int n) {
            this.rot = n;
            Dock.this.layout();
        }

        boolean isHorizontal() {
            return this.rot == 2 || this.rot == 3;
        }

        boolean isVertical() {
            return this.rot == 0 || this.rot == 1;
        }

        float getMousePos(Point point) {
            switch (this.rot) {
                case 2: 
                case 3: {
                    return point.x;
                }
            }
            return point.y;
        }

        float getCenter() {
            if (!Dock.this.autoCenter) {
                return Dock.this.offset + Dock.this.origWidth * (float)Dock.this.items.size() / 2.0f;
            }
            switch (this.rot) {
                case 2: 
                case 3: {
                    return (float)(Dock.this.canvas.width / 2) + Dock.this.offset;
                }
            }
            return (float)(Dock.this.canvas.height / 2) + Dock.this.offset;
        }

        void setRect(RoundRectangle2D.Float float_, float f) {
            float f2 = Dock.this.origWidth / 4.0f;
            switch (this.rot) {
                case 1: {
                    float_.setRoundRect((float)Dock.this.canvas.width - Dock.this.inset - f, Dock.this.curLow, f, Dock.this.curHeight, f2, f2);
                    break;
                }
                case 2: {
                    float_.setRoundRect(Dock.this.curLow, Dock.this.inset, Dock.this.curHeight, f, f2, f2);
                    break;
                }
                case 3: {
                    float_.setRoundRect(Dock.this.curLow, (float)Dock.this.canvas.height - Dock.this.inset - f, Dock.this.curHeight, f, f2, f2);
                    break;
                }
                default: {
                    float_.setRoundRect(Dock.this.inset, Dock.this.curLow, f, Dock.this.curHeight, f2, f2);
                }
            }
        }

        void positionItem(MenuItem menuItem, float f) {
            DockItem dockItem = (DockItem)menuItem;
            PGraphics pGraphics = Dock.this.canvas.g;
            switch (this.rot) {
                case 0: {
                    dockItem.setPosition(Dock.this.inset, f);
                    break;
                }
                case 1: {
                    dockItem.setPosition((float)pGraphics.width - menuItem.getWidth() - Dock.this.inset, f);
                    break;
                }
                case 2: {
                    dockItem.setPosition(f, Dock.this.inset);
                    break;
                }
                case 3: {
                    dockItem.setPosition(f, (float)pGraphics.height - menuItem.getHeight() - Dock.this.inset);
                }
            }
        }
    }
}

