/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import processing.core.PFont;
import processing.core.PGraphics;

public class CheckBox
extends MenuItem {
    public static final float CHECKBOX_SIZE = 0.8f;
    private boolean value;
    private Field field;
    private Method method;
    private Object methodObj;
    private Object fieldObj;
    private boolean useReflection;
    private float tWidth;
    private float nWidth;
    private float nOffsetX;
    private float nHeight;
    private float nOffsetY;
    static RoundRectangle2D.Float buffRoundRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);

    public boolean getCloseOnAction() {
        return false;
    }

    public void setProperty(Object object, String string) {
        try {
            this.field = object.getClass().getField(string);
            this.fieldObj = object;
            this.useReflection = true;
        }
        catch (Exception exception) {
            this.field = null;
            throw new RuntimeException();
        }
    }

    public void setMethodCall(Object object, String string) {
        try {
            this.method = object.getClass().getMethod(string, Boolean.TYPE);
            this.methodObj = object;
            this.useReflection = true;
        }
        catch (Exception exception) {
            this.method = null;
            this.methodObj = null;
            this.useReflection = false;
            throw new RuntimeException();
        }
    }

    public void setValue(String string) {
        this.setVal(Boolean.parseBoolean(string));
    }

    void setVal(boolean bl) {
        this.value = bl;
        if (this.useReflection) {
            try {
                if (this.field != null) {
                    this.field.setBoolean(this.fieldObj, bl);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (this.method != null) {
                    this.method.invoke(this.methodObj, bl);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public void drawMyself() {
        super.drawMyself();
        float f = this.getStyle().getF("f.padX");
        float f2 = this.getStyle().getF("f.padY");
        float f3 = this.x + f;
        MenuUtils.drawLeftText(this, this.getName() + ":", f3);
        f3 = this.getX() + this.getWidth() - f - this.nWidth;
        if (this.getState() == 0) {
            this.menu.buff.strokeWeight(0.5f);
            this.menu.buff.stroke(100);
            this.menu.buff.noFill();
            this.menu.buff.rect(f3, this.y + this.nOffsetY, this.nWidth, this.nHeight);
        } else if (this.shouldPerformFill()) {
            MenuUtils.drawSingleGradientRect(this, f3, this.y + this.nOffsetY, this.nWidth, this.nHeight, 0.0f);
        }
        try {
            if (this.field != null) {
                this.value = this.field.getBoolean(this.fieldObj);
            }
        }
        catch (Exception exception) {
            this.useReflection = false;
            exception.printStackTrace();
        }
        if (this.value) {
            this.drawCheckMark();
        }
    }

    private void drawCheckMark() {
        float f = this.nWidth * 0.75f;
        float f2 = this.nHeight * 0.75f;
        float f3 = this.x + this.nOffsetX + (this.nWidth - f) / 2.0f;
        float f4 = this.y + this.nOffsetY + (this.nHeight - f2) / 2.0f;
        this.menu.canvas.strokeWeight(this.nHeight / 8.0f);
        this.menu.canvas.stroke(0);
        this.menu.canvas.line(f3 + f * 0.2f, f4 + f2 * 0.6f, f3 + f * 0.5f, f4 + f2 * 0.9f);
        this.menu.canvas.line(f3 + f * 0.5f, f4 + f2 * 0.9f, f3 + f * 0.8f, f4 + f2 * 0.2f);
    }

    protected void calcPreferredSize() {
        super.calcPreferredSize();
        PFont pFont = this.getStyle().getFont("font");
        float f = this.getStyle().getF("f.fontSize");
        float f2 = this.getStyle().getF("f.padX");
        float f3 = this.getStyle().getF("f.padY");
        float f4 = UIUtils.getTextHeight((PGraphics)this.menu.buff, pFont, f, "XYZ", true);
        if (this.getName().length() > 0) {
            this.tWidth = UIUtils.getTextWidth((PGraphics)this.menu.buff, pFont, f, this.getName() + ":", true);
            this.tWidth += f2;
        }
        this.setHeight(f4 + 2.0f * f3);
        this.nOffsetX = this.getWidth() - f2 - this.nWidth;
        this.nWidth = this.nHeight = f4 * 0.8f;
        this.nOffsetY = (this.getHeight() - this.nHeight) / 2.0f;
        this.setWidth(f2 + this.tWidth + this.nWidth + f2);
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        float_2.setFrame(this.x, this.y, this.width, this.height);
        Rectangle2D.union(float_, float_2, float_);
        super.getRect(float_, float_2);
    }

    public void performAction() {
        this.setVal(!this.value);
        super.performAction();
    }

    protected void visibleMouseEvent(MouseEvent mouseEvent, Point point) {
        super.visibleMouseEvent(mouseEvent, point);
        if (!this.isEnabled()) {
            return;
        }
        if (this.mouseInside) {
            this.menu.setCursor(12);
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.mouseInside) break;
                break;
            }
            case 506: {
                break;
            }
        }
    }

    protected boolean containsPoint(Point point) {
        float f = this.getStyle().getF("f.roundOff");
        buffRoundRect.setRoundRect(this.x, this.y, this.width, this.height, f, f);
        return buffRoundRect.contains(point);
    }

    public void keyEvent(KeyEvent keyEvent) {
        super.keyEvent(keyEvent);
        if (keyEvent.getID() != 401) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this.performAction();
                break;
            }
        }
    }
}

