/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.camera;

import java.awt.geom.Rectangle2D;
import org.andrewberman.ui.camera.MovableCamera;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenQuad;
import processing.core.PApplet;

public class RectMover
extends MovableCamera {
    protected Rectangle2D.Float r = new Rectangle2D.Float();
    protected Tween wTween = new Tween(null, TweenQuad.tween, 1, 1.0f, 1.0f, this.FRAMES);
    protected Tween hTween = new Tween(null, TweenQuad.tween, 1, 1.0f, 1.0f, this.FRAMES);
    float cx;
    float cy;
    float w;
    float h = 0.0f;
    float border = 100.0f;
    static final float minZoom = 1.0E-4f;

    public RectMover(PApplet pApplet) {
        super(pApplet);
        this.update();
    }

    public void zoomBy(float f) {
        float f2 = this.wTween.getFinish() * f;
        float f3 = this.hTween.getFinish() * f;
        this.zoomCenterTo(this.cx, this.cy, f2, f3);
    }

    public void zoomTo(float f) {
        this.wTween.continueTo((float)this.p.width * f);
        this.hTween.continueTo((float)this.p.height * f);
    }

    public void zoomCenterTo(float f, float f2, float f3, float f4) {
        this.xTween.continueTo(f);
        this.yTween.continueTo(f2);
        this.wTween.continueTo(f3);
        this.hTween.continueTo(f4);
    }

    public void fforward() {
        super.fforward();
        this.wTween.fforward();
        this.hTween.fforward();
    }

    public void fillScreen(float f) {
        this.zoomCenterTo(0.0f, 0.0f, (float)this.p.getWidth() * f, (float)this.p.getHeight() * f);
    }

    public float getZ() {
        return this.w / (float)this.p.width;
    }

    public void update() {
        super.scroll();
        this.xTween.update();
        this.yTween.update();
        this.wTween.update();
        this.hTween.update();
        this.updateConvenienceVariables();
        this.constrainToScreen();
        this.r.setRect(-this.cx * this.getZ() - this.w / 2.0f, -this.cy * this.getZ() - this.h / 2.0f, this.w, this.h);
    }

    public Rectangle2D.Float getRect() {
        return this.r;
    }

    private void updateConvenienceVariables() {
        this.cx = this.xTween.getPosition();
        this.cy = this.yTween.getPosition();
        this.w = this.wTween.getPosition();
        this.h = this.hTween.getPosition();
    }

    private void constrainToScreen() {
        if (this.getZ() < 1.0E-4f) {
            this.nudgeTo(this.xTween.getBegin(), this.yTween.getBegin());
            this.zoomTo(1.0E-4f);
            this.xTween.fforward();
            this.yTween.fforward();
            this.wTween.fforward();
            this.hTween.fforward();
        }
        this.updateConvenienceVariables();
    }
}

