/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.camera;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import org.andrewberman.ui.camera.Camera;
import processing.core.PApplet;

public class MovableCamera
extends Camera
implements MouseWheelListener,
KeyListener,
MouseMotionListener,
MouseListener {
    Point2D.Float pt = new Point2D.Float(0.0f, 0.0f);
    protected int NUDGE_DISTANCE;
    protected float NUDGE_SCALE;
    protected boolean mouseInside = false;
    public boolean enableSideScrolling = false;
    public boolean respondToKeyboard = false;

    public void setRespondToKeyboard(boolean bl) {
        this.respondToKeyboard = bl;
    }

    public MovableCamera(PApplet pApplet) {
        super(pApplet);
        this.p = pApplet;
        this.makeResponsive();
        this.NUDGE_DISTANCE = pApplet.width / 5;
        this.NUDGE_SCALE = 10.0f / (float)this.NUDGE_DISTANCE;
    }

    public void makeResponsive() {
        this.p.addMouseListener((MouseListener)this);
        this.p.addMouseMotionListener((MouseMotionListener)this);
        this.p.addMouseWheelListener((MouseWheelListener)this);
        this.p.addKeyListener((KeyListener)this);
    }

    public void makeUnresponsive() {
        this.p.removeMouseListener((MouseListener)this);
        this.p.removeMouseMotionListener((MouseMotionListener)this);
        this.p.removeMouseWheelListener((MouseWheelListener)this);
        this.p.removeKeyListener((KeyListener)this);
    }

    public void update() {
        this.xTween.update();
        this.yTween.update();
        this.zTween.update();
        this.scroll();
        this.applyTransformations();
    }

    public void scroll() {
        if (this.mouseInside && this.enableSideScrolling) {
            this.pt.setLocation(this.p.mouseX, this.p.mouseY);
            float f = this.NUDGE_SCALE / this.getZ();
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.pt.y > (float)(this.p.height - this.NUDGE_DISTANCE)) {
                f2 = (float)this.NUDGE_DISTANCE - ((float)this.p.height - this.pt.y);
            } else if (this.pt.y < (float)this.NUDGE_DISTANCE) {
                f2 = -((float)this.NUDGE_DISTANCE - this.pt.y);
            }
            if (this.pt.x > (float)(this.p.width - this.NUDGE_DISTANCE)) {
                f3 = (float)this.NUDGE_DISTANCE - ((float)this.p.width - this.pt.x);
            } else if (this.pt.x < (float)this.NUDGE_DISTANCE) {
                f3 = -((float)this.NUDGE_DISTANCE - this.pt.x);
            }
            if (f2 != 0.0f || f3 != 0.0f) {
                this.nudge(f3 * f, f2 * f);
            }
        }
    }

    public float getStageWidth() {
        return this.p.width;
    }

    public float getStageHeight() {
        return this.p.height;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.zTween.stop();
        float f = 1.5f;
        int n = mouseWheelEvent.getWheelRotation() < 0 ? 1 : -1;
        float f2 = (float)Math.pow(f, n);
        this.pt.setLocation(mouseWheelEvent.getX(), mouseWheelEvent.getY());
        float f3 = (float)(this.p.width / 2) - this.pt.x;
        float f4 = (float)(this.p.height / 2) - this.pt.y;
        float f5 = this.getZ() * f2;
        f3 = f3 / f5 * (1.0f - f2);
        f4 = f4 / f5 * (1.0f - f2);
        this.zoomBy(f2);
        this.nudge(f3, f4);
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return;
        }
        if (!this.respondToKeyboard) {
            return;
        }
        System.out.println(keyEvent.getKeyCode());
        int n = keyEvent.getKeyCode();
        float f = 10.0f / this.getZ();
        switch (n) {
            case 81: {
                this.zoomBy(2.0f);
                break;
            }
            case 87: {
                this.zoomBy(0.5f);
                break;
            }
            case 37: {
                this.nudge(-f, 0.0f);
                break;
            }
            case 39: {
                this.nudge(f, 0.0f);
                break;
            }
            case 38: {
                this.nudge(0.0f, -f);
                break;
            }
            case 40: {
                this.nudge(0.0f, f);
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 503: 
            case 506: {
                break;
            }
            case 505: {
                this.mouseInside = false;
                break;
            }
            case 504: {
                this.mouseInside = true;
                break;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }
}

