/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.camera;

import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenFriction;
import processing.core.PApplet;

public class Camera {
    protected Tween xTween;
    protected Tween yTween;
    protected Tween zTween;
    protected int FRAMES = 15;
    protected PApplet p;

    public Camera(PApplet pApplet) {
        this.p = pApplet;
        this.xTween = new Tween(null, TweenFriction.tween(0.2f), 1, 0.0f, 0.0f, 0.0f);
        this.yTween = new Tween(null, TweenFriction.tween(0.2f), 1, 0.0f, 0.0f, 0.0f);
        this.zTween = new Tween(null, TweenFriction.tween(0.2f), 1, 1.0f, 1.0f, 0.0f);
    }

    public void zoomCenterTo(float f, float f2, float f3, float f4) {
        float f5;
        float f6 = f3 / this.getStageWidth();
        if (f6 > (f5 = f4 / this.getStageHeight())) {
            this.zTween.continueTo(1.0f / f6);
            this.xTween.continueTo(f / f6);
            this.yTween.continueTo(f2 / f6);
        } else {
            this.zTween.continueTo(1.0f / f5);
            this.yTween.continueTo(f2 / f5);
            this.xTween.continueTo(f / f5);
        }
    }

    public void zoomBy(float f) {
        this.zTween.continueTo(this.zTween.getFinish() * f);
    }

    public void zoomTo(float f) {
        this.zTween.continueTo(f);
    }

    protected void applyTransformations() {
        this.p.translate(this.getStageWidth() / 2.0f, this.getStageHeight() / 2.0f);
        this.p.scale(this.getZ());
        this.p.translate(-this.getX(), -this.getY());
    }

    public void nudge(float f, float f2) {
        this.nudgeTo(this.xTween.getFinish() + f, this.yTween.getFinish() + f2);
    }

    public void nudgeTo(float f, float f2) {
        this.xTween.continueTo(f);
        this.yTween.continueTo(f2);
    }

    public void skipTo(float f, float f2) {
        this.nudgeTo(f, f2);
        this.xTween.fforward();
        this.yTween.fforward();
    }

    public void fforward() {
        this.xTween.fforward();
        this.yTween.fforward();
        this.zTween.fforward();
    }

    public float getStageWidth() {
        return this.p.width;
    }

    public float getStageHeight() {
        return this.p.height;
    }

    public float getX() {
        return this.xTween.getPosition();
    }

    public float getY() {
        return this.yTween.getPosition();
    }

    public float getZ() {
        return this.zTween.getPosition();
    }

    public void update() {
        this.xTween.update();
        this.yTween.update();
        this.zTween.update();
        this.applyTransformations();
    }
}

