/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Point;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;

public final class UIUtils {
    static Cursor baseCursor = Cursor.getDefaultCursor();
    private static PMatrix3D camera = new PMatrix3D();
    private static PMatrix3D cameraInv = new PMatrix3D();
    static Object cursorOwner;
    private static PMatrix3D modelview;
    private static PMatrix3D modelviewInv;
    private static double[] temp;
    private static Point tPoint;

    public static void affineToPMatrix3D(AffineTransform affineTransform, PMatrix3D pMatrix3D) {
        affineTransform.getMatrix(temp);
        pMatrix3D.set((float)temp[0], (float)temp[2], 0.0f, (float)temp[4], (float)temp[1], (float)temp[3], 0.0f, (float)temp[5], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static int colorToInt(PGraphics pGraphics, Color color) {
        return pGraphics.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Cursor createBlankCursor(PApplet pApplet) {
        Image image = pApplet.createImage((ImageProducer)new MemoryImageSource(0, 0, new int[0], 0, 0));
        return Toolkit.getDefaultToolkit().createCustomCursor(image, new java.awt.Point(0, 0), "asdf");
    }

    public static Cursor createCursor(PApplet pApplet, String string, int n, int n2) {
        InputStream inputStream = pApplet.createInput(string);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage2, new java.awt.Point(n, n2), "asdf");
    }

    public static Object getCursorOwner() {
        return cursorOwner;
    }

    public static int getMetaMask() {
        return 128;
    }

    public static FontMetrics getMetrics(PGraphics pGraphics, Font font, float f) {
        if (pGraphics == null) {
            return null;
        }
        Graphics2D graphics2D = ((PGraphicsJava2D)pGraphics).g2;
        if (graphics2D == null) {
            return null;
        }
        if (font == null) {
            return null;
        }
        Font font2 = font.deriveFont(f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        return fontMetrics;
    }

    public static float getTextAscent(PGraphics pGraphics, PFont pFont, float f, boolean bl) {
        FontMetrics fontMetrics;
        if (UIUtils.isJava2D(pGraphics) && bl && (fontMetrics = UIUtils.getMetrics(pGraphics, pFont.getFont(), f)) != null) {
            return fontMetrics.getAscent();
        }
        return pFont.ascent() * f;
    }

    public static float getTextDescent(PGraphics pGraphics, PFont pFont, float f, boolean bl) {
        FontMetrics fontMetrics;
        if (UIUtils.isJava2D(pGraphics) && bl && (fontMetrics = UIUtils.getMetrics(pGraphics, pFont.getFont(), f)) != null) {
            return fontMetrics.getDescent();
        }
        return pFont.descent() * f;
    }

    public static float getTextHeight(PGraphics pGraphics, PFont pFont, float f, String string, boolean bl) {
        FontMetrics fontMetrics;
        if (UIUtils.isJava2D(pGraphics) && bl && (fontMetrics = UIUtils.getMetrics(pGraphics, pFont.getFont(), f)) != null) {
            return fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        return pFont.ascent() * f + pFont.descent() * f;
    }

    public static Rectangle2D getTextRect(PGraphics pGraphics, PFont pFont, float f, String string, boolean bl) {
        Serializable serializable;
        if (UIUtils.isJava2D(pGraphics) && bl && (serializable = UIUtils.getMetrics(pGraphics, pFont.getFont(), f)) != null) {
            Graphics2D graphics2D = ((PGraphicsJava2D)pGraphics).g2;
            return ((FontMetrics)serializable).getStringBounds(string, graphics2D);
        }
        serializable = new Rectangle2D.Float();
        ((Rectangle2D.Float)serializable).width = UIUtils.getTextWidth(pGraphics, pFont, f, string, bl);
        ((Rectangle2D.Float)serializable).height = UIUtils.getTextHeight(pGraphics, pFont, f, string, bl);
        return serializable;
    }

    public static float getTextWidth(PGraphics pGraphics, PFont pFont, float f, String string, boolean bl) {
        Object object;
        if (UIUtils.isJava2D(pGraphics) && bl) {
            object = null;
            while (object == null) {
                try {
                    object = UIUtils.getMetrics(pGraphics, pFont.getFont(), f);
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        object = string.toCharArray();
        float f2 = 0.0f;
        for (int i = 0; i < ((char[])object).length; ++i) {
            f2 += pFont.width(object[i]) * f;
        }
        return f2;
    }

    public static float getTextWidth(Graphics2D graphics2D, Font font, float f, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font.deriveFont(f));
        return (float)fontMetrics.getStringBounds(string, graphics2D).getWidth();
    }

    public static float getTextHeight(Graphics2D graphics2D, Font font, float f, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font.deriveFont(f));
        return (float)fontMetrics.getStringBounds(string, graphics2D).getHeight();
    }

    public static boolean isJava2D(PApplet pApplet) {
        return UIUtils.isJava2D(pApplet.g);
    }

    public static boolean isJava2D(PGraphics pGraphics) {
        boolean bl = pGraphics.getClass() == PGraphicsJava2D.class;
        return bl;
    }

    public static void modelToScreen(Point2D.Float float_) {
        UIUtils.transform(modelview, float_);
        UIUtils.transform(cameraInv, float_);
    }

    public static Image PImageToImage(PApplet pApplet, PImage pImage) {
        Image image = pImage.getImage();
        return image;
    }

    public static void releaseCursor(Object object, PApplet pApplet) {
        if (cursorOwner != object) {
            return;
        }
        cursorOwner = null;
        pApplet.setCursor(baseCursor);
    }

    public static void resetMatrix(PApplet pApplet) {
        UIUtils.resetMatrix(pApplet.g);
    }

    public static void resetMatrix(PGraphics pGraphics) {
        if (UIUtils.isJava2D(pGraphics)) {
            pGraphics.resetMatrix();
        } else {
            pGraphics.camera();
        }
    }

    public static void screenToModel(Point2D.Float float_) {
        UIUtils.transform(camera, float_);
        UIUtils.transform(modelviewInv, float_);
    }

    public static void screenToModel(Rectangle2D.Float float_) {
        UIUtils.tPoint.x = float_.x;
        UIUtils.tPoint.y = float_.y;
        UIUtils.transform(camera, tPoint);
        UIUtils.transform(modelviewInv, tPoint);
        float f = UIUtils.tPoint.x;
        float f2 = UIUtils.tPoint.y;
        UIUtils.tPoint.x = float_.x + float_.width;
        UIUtils.tPoint.y = float_.y;
        UIUtils.transform(camera, tPoint);
        UIUtils.transform(modelviewInv, tPoint);
        float f3 = UIUtils.tPoint.x;
        float f4 = UIUtils.tPoint.y;
        UIUtils.tPoint.x = float_.x + float_.width;
        UIUtils.tPoint.y = float_.y + float_.height;
        UIUtils.transform(camera, tPoint);
        UIUtils.transform(modelviewInv, tPoint);
        float f5 = UIUtils.tPoint.x;
        float f6 = UIUtils.tPoint.y;
        UIUtils.tPoint.x = float_.x;
        UIUtils.tPoint.y = float_.y + float_.height;
        UIUtils.transform(camera, tPoint);
        UIUtils.transform(modelviewInv, tPoint);
        float f7 = UIUtils.tPoint.x;
        float f8 = UIUtils.tPoint.y;
        float f9 = PApplet.min((float[])new float[]{f, f3, f5, f7});
        float f10 = PApplet.min((float[])new float[]{f2, f4, f6, f8});
        float f11 = PApplet.max((float[])new float[]{f, f3, f5, f7});
        float f12 = PApplet.max((float[])new float[]{f2, f4, f6, f8});
        float_.setFrameFromDiagonal(f9, f10, f11, f12);
    }

    public static void setBaseCursor(PApplet pApplet, Cursor cursor) {
        baseCursor = cursor;
        if (cursorOwner == null) {
            pApplet.setCursor(baseCursor);
        }
    }

    public static void setCursor(Object object, PApplet pApplet, int n) {
        cursorOwner = object;
        pApplet.setCursor(Cursor.getPredefinedCursor(n));
    }

    public static void setMatrix(PApplet pApplet) {
        if (UIUtils.isJava2D(pApplet)) {
            PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)pApplet.g;
            AffineTransform affineTransform = pGraphicsJava2D.g2.getTransform();
            try {
                UIUtils.affineToPMatrix3D(affineTransform, modelview);
                UIUtils.affineToPMatrix3D(affineTransform.createInverse(), modelviewInv);
                camera.reset();
                cameraInv.reset();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return;
            }
        } else {
            pApplet.g.getMatrix();
            camera.set(pApplet.g.getMatrix());
            PMatrix pMatrix = pApplet.g.getMatrix();
            pMatrix.invert();
            cameraInv.set(pMatrix);
        }
    }

    public static void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void setRenderingHints(PGraphics pGraphics) {
        if (pGraphics instanceof PGraphicsJava2D) {
            PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)pGraphics;
            pGraphics.smooth();
            Graphics2D graphics2D = pGraphicsJava2D.g2;
            UIUtils.setRenderingHints(graphics2D);
        }
    }

    public static void transform(PMatrix3D pMatrix3D, Point2D.Float float_) {
        float f = float_.x;
        float f2 = float_.y;
        float f3 = 0.0f;
        float_.x = pMatrix3D.m00 * f + pMatrix3D.m01 * f2 + pMatrix3D.m02 * f3 + pMatrix3D.m03;
        float_.y = pMatrix3D.m10 * f + pMatrix3D.m11 * f2 + pMatrix3D.m12 * f3 + pMatrix3D.m13;
    }

    static {
        modelview = new PMatrix3D();
        modelviewInv = new PMatrix3D();
        temp = new double[6];
        tPoint = new Point(0.0f, 0.0f);
    }
}

