/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.Blinker;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.StringClipboard;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.ifaces.Malleable;
import org.andrewberman.ui.menu.MenuStyle;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;

public class TextField
extends AbstractUIObject
implements Malleable {
    static final int LEFT = -1;
    static final int RIGHT = 1;
    static final int SELECT = 0;
    static final int MOVE = 1;
    static final int CARET_JUMP = 1;
    static final int DRAG_BORDER_FACTOR = 10;
    static final int MOUSE_DRAG_DELAY = 1;
    static final float TEXT_BORDER_MULT = 0.1f;
    static final int metaMask = UIUtils.getMetaMask();
    static final int OFFSET = 10;
    PApplet canvas;
    PGraphicsJava2D pg;
    TextFieldStyle style;
    PFont pFont;
    Font font;
    float fontSize;
    Blinker blinker;
    StringClipboard clip;
    Rectangle2D.Float clipRect;
    Rectangle2D.Float buffRect;
    RenderingHints oldRH;
    float offsetX;
    float offsetY;
    float ascent;
    float descent;
    float x;
    float y;
    float width;
    float height;
    float pad;
    float mouseDragPos;
    int mouseDragCounter;
    int caret;
    int anchorPos;
    int selAnchor;
    int viewLo;
    int viewHi;
    int selLo;
    int selHi;
    boolean anchorRight;
    boolean mouseDragging;
    boolean shiftPressed;
    protected boolean hidden;
    public StringBuffer text = new StringBuffer();
    public boolean useCameraCoordinates = true;
    public boolean alwaysAnchorLeft = false;
    float lastWidth = 0.0f;

    public TextField(PApplet pApplet) {
        StringClipboard.lazyLoad();
        Blinker.lazyLoad();
        this.canvas = pApplet;
        this.style = new TextFieldStyle();
        this.style.set("f.fontSize", 12);
        this.pFont = this.style.getFont("font");
        this.font = this.pFont.getFont();
        this.blinker = Blinker.instance;
        this.clipRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        this.buffRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        this.clip = StringClipboard.instance;
        this.width = 50.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        if (UIUtils.isJava2D(this.canvas)) {
            this.pg = (PGraphicsJava2D)this.canvas.g;
            this.layout();
        } else {
            this.pg = this.createBuffer(10, 10);
            this.layout();
        }
        UIGlobals.g.event().add(this);
    }

    PGraphicsJava2D createBuffer(int n, int n2) {
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.canvas.createGraphics(n, n2, "processing.core.PGraphicsJava2D");
        return pGraphicsJava2D;
    }

    protected void reset() {
        this.anchorRight = false;
        this.selHi = 0;
        this.selLo = 0;
        this.anchorPos = 0;
        this.caret = 0;
        this.mouseDragging = false;
        this.shiftPressed = false;
    }

    protected void layout() {
        this.ascent = UIUtils.getTextAscent((PGraphics)this.pg, this.pFont, this.fontSize, true);
        this.descent = UIUtils.getTextDescent((PGraphics)this.pg, this.pFont, this.fontSize, true);
        float f = this.ascent + this.descent;
        this.pad = f * 0.1f;
        this.height = f;
        this.offsetY = this.ascent;
        if (!UIUtils.isJava2D(this.canvas)) {
            float f2 = this.height + this.pad * 2.0f + 20.0f;
            float f3 = this.width + this.pad * 2.0f + 20.0f;
            if ((float)this.pg.width < f3 || (float)this.pg.height < f2) {
                this.pg = this.createBuffer((int)f3, (int)f2);
            }
            this.hint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (this.hidden) {
            return;
        }
        this.calculateViewport();
        this.canvas.pushMatrix();
        this.resetMatrix();
        if (!UIUtils.isJava2D(this.canvas)) {
            this.pg.beginDraw();
            this.pg.background(255, 0.0f);
            this.pg.translate(-this.x, -this.y);
            this.pg.translate(10.0f, 10.0f);
            this.doTheDrawing();
            this.pg.setModified(true);
            this.pg.endDraw();
            this.drawToCanvas();
        } else {
            StringBuffer stringBuffer = this.text;
            synchronized (stringBuffer) {
                this.doTheDrawing();
            }
        }
        this.canvas.popMatrix();
    }

    public void hide() {
        this.hidden = true;
        UIUtils.releaseCursor(this, this.canvas);
    }

    public void show() {
        this.hidden = false;
    }

    protected void drawToCanvas() {
        int n = (int)(this.width + 20.0f);
        int n2 = (int)(this.height + 20.0f);
        this.canvas.image((PImage)this.pg, (float)((int)(this.x - 10.0f)), (float)((int)(this.y - 10.0f)), (float)n, (float)n2, 0, 0, n, n2);
    }

    protected void resetMatrix() {
        if (this.useCameraCoordinates) {
            return;
        }
        if (UIUtils.isJava2D(this.canvas)) {
            this.canvas.resetMatrix();
        } else {
            this.canvas.camera();
        }
    }

    public void dispose() {
        UIGlobals.g.event().remove(this);
        this.blinker.stop();
        this.blinker = null;
    }

    protected void doTheDrawing() {
        int n;
        Color color = this.style.getC("c.backgroundFill");
        Color color2 = this.style.getC("c.foreground");
        this.clipRect.setRect(this.x, this.y, this.width + 2.0f * this.pad, this.height + 2.0f * this.pad);
        this.pg.g2.setPaint(Color.white);
        this.pg.g2.fill(this.clipRect);
        this.pg.g2.setPaint(color2);
        this.pg.g2.setStroke(new BasicStroke(this.style.getF("f.strokeWeight")));
        this.pg.g2.draw(this.clipRect);
        this.clipRect.setRect(this.x + this.pad, this.y + this.pad, this.width, this.height);
        this.pg.g2.setClip(this.clipRect);
        this.pg.g2.setFont(this.pFont.getFont().deriveFont(this.fontSize));
        this.pg.g2.setPaint(color2);
        this.pg.g2.drawString(this.substring(this.viewLo, this.viewHi), this.x + this.pad + this.offsetX, this.y + this.pad + this.offsetY);
        if (this.selHi - this.selLo > 0) {
            n = Math.max(this.viewLo, this.selLo);
            int n2 = Math.min(this.viewHi, this.selHi);
            float f = this.getPosForIndex(n);
            float f2 = this.getWidth(n, n2);
            this.clipRect.setRect(this.x + f + this.pad, this.y + this.pad, f2, this.height);
            this.pg.g2.setPaint(this.style.getC("c.highlight"));
            this.pg.g2.fill(this.clipRect);
            this.pg.g2.setClip(this.clipRect);
            this.pg.g2.setPaint(color2.inverse());
            this.pg.g2.drawString(this.substring(n, n2), this.x + this.pad + f, this.y + this.pad + this.offsetY);
        }
        if (this.blinker.isOn && UIGlobals.g.focus().isFocused(this) && this.selHi - this.selLo == 0) {
            this.pg.g2.setStroke(new BasicStroke(1.0f));
            this.pg.g2.setPaint(color2);
            n = (int)(this.x + this.pad + this.getPosForIndex(this.caret));
            if (this.caret == this.text.length() && this.caret != 0) {
                --n;
            }
            this.pg.g2.drawLine(n, (int)(this.y + this.pad + this.height / 10.0f), n, (int)(this.y + this.pad + this.height - this.height / 10.0f));
        }
        this.pg.g2.setClip(null);
        this.handleDragScroll();
    }

    private synchronized String substring(int n, int n2) {
        if (n2 > this.text.length()) {
            n2 = this.text.length();
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 - n == 0) {
            return "";
        }
        return this.text.substring(n, n2);
    }

    protected void handleDragScroll() {
        if (!this.mouseDragging) {
            return;
        }
        --this.mouseDragCounter;
        if (this.mouseDragCounter <= 0) {
            this.mouseDragCounter = 1;
            if ((double)this.mouseDragPos < (double)this.x + (double)(this.width / 10.0f) / 2.0) {
                this.selectChar(-1);
                ++this.mouseDragCounter;
            }
            if ((double)this.mouseDragPos > (double)(this.x + this.width) - (double)(this.width / 10.0f) / 2.0) {
                this.selectChar(1);
                ++this.mouseDragCounter;
            }
        }
    }

    protected void hint() {
        this.oldRH = this.pg.g2.getRenderingHints();
        this.pg.g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.pg.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.pg.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void unhint() {
        this.pg.g2.setRenderingHints(this.oldRH);
    }

    protected void calculateViewport() {
        if (this.anchorRight) {
            int n;
            float f = 0.0f;
            for (n = this.viewHi = this.anchorPos; f <= this.width && n > 0; --n) {
                f = this.getWidth(n - 1, this.viewHi);
            }
            this.viewLo = n;
            this.offsetX = this.width - f;
        } else {
            int n;
            float f = 0.0f;
            for (n = this.viewLo = this.anchorPos; f <= this.width && n < this.text.length(); ++n) {
                f = this.getWidth(this.viewLo, n + 1);
            }
            this.viewHi = n;
            this.offsetX = 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getWidth(int n, int n2) {
        if (n > n2) {
            n = Math.min(n, n2);
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = this.text;
        synchronized (stringBuffer) {
            try {
                float f;
                FontMetrics fontMetrics = UIUtils.getMetrics((PGraphics)this.pg, this.pFont.getFont(), this.fontSize);
                this.lastWidth = f = (float)fontMetrics.getStringBounds(this.text.substring(n, n2), this.pg.g2).getWidth();
                return f;
            }
            catch (Exception exception) {
                return this.lastWidth;
            }
        }
    }

    protected float getPosForIndex(int n) {
        return this.offsetX + this.getWidth(this.viewLo, n);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setPosition(float f, float f2) {
        this.setPositionByCorner(f, f2);
    }

    public void setPositionByCorner(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setPositionByBaseline(float f, float f2) {
        this.x = f - this.pad;
        this.y = f2 - this.ascent - this.pad;
    }

    public void setTextSize(float f) {
        this.fontSize = f;
        this.layout();
    }

    public void setWidth(float f) {
        this.width = f;
        this.layout();
    }

    protected void selectAll() {
        this.selAnchor = 0;
        this.selectChar(this.text.length());
    }

    protected void selectWord(int n) {
        this.nextWord(0, n);
    }

    protected void selectToEnd(int n) {
        if (n == -1) {
            this.selectChar(0 - this.caret);
        } else if (n == 1) {
            this.selectChar(this.text.length() - this.caret);
        }
    }

    protected void moveToEnd(int n) {
        if (n == -1) {
            this.moveChar(0 - this.caret);
        } else if (n == 1) {
            this.moveChar(this.text.length() - this.caret);
        }
    }

    protected void moveWord(int n) {
        this.nextWord(1, n);
    }

    protected void nextWord(int n, int n2) {
        this.nextWord(n, n2, true);
    }

    protected void nextWord(int n, int n2, boolean bl) {
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        String string = "";
        if (n2 == 1) {
            string = this.text.substring(this.caret, this.text.length());
            String[] stringArray = string.split("\\w\\W", 2);
            String string2 = stringArray[0];
            if (n == 0) {
                this.selectChar(string2.length() + n3);
            } else {
                this.moveChar(string2.length() + n3);
            }
        } else if (n2 == -1) {
            string = this.text.reverse().substring(this.text.length() - this.caret, this.text.length());
            this.text.reverse();
            String[] stringArray = string.split("\\W\\w", 2);
            String string3 = stringArray[0];
            if (n == 0) {
                this.selectChar(-1 * (string3.length() + 1));
            } else {
                this.moveChar(-1 * (string3.length() + 1));
            }
        }
    }

    protected void selectChar(int n) {
        this.selLo = Math.min(this.caret + n, this.selAnchor);
        this.selHi = Math.max(this.caret + n, this.selAnchor);
        if (this.selLo < 0) {
            this.selLo = 0;
        }
        if (this.selHi > this.text.length()) {
            this.selHi = this.text.length();
        }
        this.moveCaretTo(this.caret + n);
    }

    protected void moveChar(int n) {
        if (this.caret + n > this.text.length()) {
            n = this.text.length() - this.caret;
        }
        if (this.caret + n < 0) {
            n = 0 - this.caret;
        }
        this.moveCaretTo(this.caret + n);
        this.clearSelection();
    }

    protected void moveCaretTo(int n) {
        this.caret = n;
        if (this.caret > this.text.length()) {
            this.caret = this.text.length();
        } else if (this.caret < 0) {
            this.caret = 0;
        }
        if (this.getWidth(0, this.text.length()) <= this.width) {
            this.anchorRight = false;
            this.anchorPos = 0;
        } else if (this.viewLo + 1 > this.caret) {
            this.anchorPos = this.caret - 1;
            this.anchorRight = false;
        } else if (this.viewHi - 1 < this.caret) {
            this.anchorPos = this.caret + 1;
            this.anchorRight = true;
        }
        if (this.alwaysAnchorLeft) {
            this.anchorRight = false;
            this.anchorPos = 0;
        }
        if (this.anchorPos > this.text.length()) {
            this.anchorPos = this.text.length();
        } else if (this.anchorPos < 0) {
            this.anchorPos = 0;
        }
        this.blinker.reset();
        this.fireEvent(2);
    }

    protected void insertCharAt(char c, int n) {
        this.insert(String.valueOf(c), n);
        this.fireEvent(0);
    }

    protected void insert(String string, int n) {
        this.text.insert(n, string);
        this.moveChar(string.length());
        this.fireEvent(0);
    }

    protected void backspaceAt(int n) {
        if (n <= 0) {
            return;
        }
        this.deleteAt(n - 1);
        this.moveCaretTo(n - 1);
        this.fireEvent(0);
    }

    protected void deleteAt(int n) {
        if (n < 0 || n >= this.text.length()) {
            return;
        }
        this.text.deleteCharAt(n);
        this.moveChar(0);
        this.fireEvent(0);
    }

    protected void deleteRange(int n, int n2) {
        for (int i = n2; i >= n; --i) {
            this.deleteAt(i);
        }
    }

    protected void deleteSelection() {
        this.deleteRange(this.selLo, this.selHi);
        this.moveCaretTo(this.selLo);
        this.clearSelection();
        this.fireEvent(0);
    }

    protected void clearSelection() {
        this.selHi = this.selLo = this.caret;
        this.selAnchor = this.caret;
        this.fireEvent(1);
    }

    protected void cut() {
        String string = this.getText(this.selLo, this.selHi);
        this.clip.toClipboard(string);
        this.deleteSelection();
    }

    protected void copy() {
        this.clip.toClipboard(this.text.substring(this.selLo, this.selHi));
    }

    protected void paste() {
        if (this.selHi - this.selLo > 0) {
            this.deleteSelection();
        }
        String string = this.clip.fromClipboard();
        this.insert(string, this.caret);
    }

    public void replaceText(String string) {
        this.selectAll();
        this.deleteSelection();
        this.insert(string, 0);
    }

    public String getText(int n, int n2) {
        return this.text.substring(n, n2);
    }

    public String getText() {
        return this.getText(0, this.text.length());
    }

    protected synchronized void printState() {
        System.err.println("Text: " + this.text.toString());
        System.err.println("Text length: " + this.text.length());
        System.err.println("Anchor: " + (this.anchorRight ? "Right" : "Left") + "   Position: " + this.anchorPos);
        System.err.println("View Low: " + this.viewLo + "   View High: " + this.viewHi);
        System.err.println("Caret Position: " + this.caret);
        System.err.println("Selection: " + this.text.substring(this.selLo, this.selHi));
        System.err.println("");
    }

    public void keyEvent(KeyEvent keyEvent) {
        char c;
        boolean bl;
        if (this.hidden) {
            return;
        }
        if (!UIGlobals.g.focus().isFocused(this)) {
            return;
        }
        int n = keyEvent.getKeyCode();
        boolean bl2 = (keyEvent.getModifiersEx() & metaMask) != 0;
        boolean bl3 = (keyEvent.getModifiersEx() & 0x200) == 512;
        this.shiftPressed = bl = (keyEvent.getModifiersEx() & 0x40) == 64;
        boolean bl4 = bl2;
        if (PApplet.platform == 2) {
            bl4 = bl3;
        }
        boolean bl5 = false;
        if (PApplet.platform == 2) {
            bl5 = bl2;
        }
        if (keyEvent.getID() == 401) {
            int n2 = 0;
            switch (n) {
                case 37: {
                    n2 = -1;
                    break;
                }
                case 39: {
                    n2 = 1;
                    break;
                }
                case 8: {
                    if (this.selHi - this.selLo > 0) {
                        this.deleteSelection();
                        break;
                    }
                    this.backspaceAt(this.caret);
                    break;
                }
                case 127: {
                    if (this.selHi - this.selLo > 0) {
                        this.deleteSelection();
                        break;
                    }
                    this.deleteAt(this.caret);
                    break;
                }
                case 36: {
                    if (bl) {
                        this.selectChar(-this.caret);
                        break;
                    }
                    this.moveChar(-this.caret);
                    break;
                }
                case 35: {
                    if (bl) {
                        this.selectChar(this.text.length() - this.caret);
                        break;
                    }
                    this.moveChar(this.text.length() - this.caret);
                    break;
                }
                case 9: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 88: {
                    if (!bl2) break;
                    this.cut();
                    break;
                }
                case 67: {
                    if (!bl2) break;
                    this.copy();
                    break;
                }
                case 86: {
                    if (!bl2) break;
                    this.paste();
                    break;
                }
                case 65: {
                    if (!bl2) break;
                    this.selectAll();
                }
            }
            if (n2 != 0) {
                if (bl && bl4) {
                    this.selectWord(n2);
                } else if (bl4) {
                    this.moveWord(n2);
                } else if (bl && bl5) {
                    this.selectToEnd(n2);
                } else if (bl5) {
                    this.moveToEnd(n2);
                } else if (bl) {
                    this.selectChar(n2);
                } else {
                    this.moveChar(n2);
                }
            }
            if (!Character.isISOControl(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        } else if (keyEvent.getID() == 400 && !Character.isISOControl(c = keyEvent.getKeyChar())) {
            if (this.selHi - this.selLo != 0) {
                this.deleteSelection();
            }
            this.insertCharAt(c, this.caret);
        }
    }

    protected boolean withinOuterRect(Point point) {
        this.buffRect.setRect(this.x, this.y, this.width + 2.0f * this.pad, this.height + 2.0f * this.pad);
        return this.buffRect.contains(point);
    }

    protected boolean withinInnerRect(Point point) {
        this.buffRect.setRect(this.x + this.pad, this.y + this.pad, this.width, this.height);
        return this.buffRect.contains(point);
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        if (this.hidden) {
            return;
        }
        Point point3 = this.useCameraCoordinates ? point2 : point;
        Point point4 = new Point(point3.x, point3.y);
        if (mouseEvent.getID() != 506) {
            this.mouseDragging = false;
            if (UIGlobals.g.focus().isFocused(this) && UIGlobals.g.focus().isModal()) {
                UIGlobals.g.focus().removeFromFocus(this);
                UIGlobals.g.focus().setFocus(this);
            }
        }
        if (mouseEvent.getID() == 503 || mouseEvent.getID() == 502 || mouseEvent.getID() == 504 || mouseEvent.getID() == 505) {
            if (this.withinInnerRect(point4) || this.mouseDragging) {
                UIUtils.setCursor(this, this.canvas, 2);
            } else {
                UIUtils.releaseCursor(this, this.canvas);
            }
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.withinOuterRect(point4) || this.mouseDragging) {
            if (this.withinInnerRect(point4) || this.mouseDragging) {
                float f;
                float f2;
                UIGlobals.g.focus().setFocus(this);
                int n = this.viewLo;
                float f3 = f2 = this.x + this.getPosForIndex(this.viewLo);
                int n2 = this.viewLo;
                while (n2 <= this.viewHi) {
                    float f4 = this.x + this.getPosForIndex(n2);
                    n = n2++;
                    f3 = f2;
                    f2 = f4;
                    if (f4 > point4.x) break;
                }
                if (point4.x < (f = (f2 + f3) / 2.0f)) {
                    --n;
                }
                int n3 = n - this.caret;
                if (mouseEvent.getID() == 506) {
                    this.mouseDragging = true;
                    UIGlobals.g.focus().setModalFocus(this);
                    this.mouseDragPos = point4.x;
                    if (n > 1 && n < this.text.length() - 1) {
                        this.handleDragScroll();
                    }
                    this.selectChar(n3);
                } else if (mouseEvent.getID() == 501) {
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            if (this.shiftPressed) {
                                this.selectChar(n3);
                                break;
                            }
                            this.moveChar(n3);
                            break;
                        }
                        case 2: {
                            this.moveChar(n3);
                            this.nextWord(1, 1, false);
                            this.nextWord(0, -1, false);
                            break;
                        }
                        case 3: {
                            this.selectAll();
                        }
                    }
                }
            }
        } else if (mouseEvent.getID() == 501 && UIGlobals.g.focus().removeFromFocus(this)) {
            this.clearSelection();
        }
    }

    public void focusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            // empty if block
        }
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getBaselineY() {
        return this.y + this.pad + this.ascent;
    }

    public float getHeight() {
        return this.height + 2.0f * this.pad;
    }

    public float getWidth() {
        return this.width + 2.0f * this.pad;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setHeight(float f) {
    }

    public void setSize(float f, float f2) {
    }

    public StringBuffer getTextModel() {
        return this.text;
    }

    class TextFieldStyle
    extends MenuStyle {
        public TextFieldStyle() {
            this.set("c.highlight", new Color(40, 40, 255));
            this.set("c.backgroundFill", new Color(255, 255, 255));
        }
    }
}

