/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class StringClipboard
implements ClipboardOwner {
    public static StringClipboard instance;
    private Clipboard clip;
    private DataFlavor flavor = DataFlavor.stringFlavor;

    public static void lazyLoad() {
        if (instance == null) {
            instance = new StringClipboard();
        }
    }

    private StringClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl = false;
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
                bl = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.clip = bl ? Toolkit.getDefaultToolkit().getSystemClipboard() : new Clipboard("PhyloWidget Clipboard");
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void toClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        this.clip.setContents(stringSelection, this);
    }

    public String fromClipboard() {
        Transferable transferable = this.clip.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(this.flavor)) {
            try {
                return (String)transferable.getTransferData(this.flavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                return "";
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return "";
            }
        }
        return new String("");
    }

    public Clipboard getClipboard() {
        return this.clip;
    }
}

