/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.andrewberman.ui.Action;
import org.andrewberman.ui.UIUtils;

public class Shortcut {
    public Action action;
    public int keyMask;
    public int keyCode;
    public String label;
    String origS;
    static String control = "(control|ctrl|meta|cmd|command|apple)";
    static String alt = "(alt)";
    static String shift = "(shift|shft)";
    static int shortcutMask = UIUtils.getMetaMask();

    public Shortcut(String string) {
        this.origS = string;
        this.parseString(string);
    }

    public void parseString(String string) {
        String string2;
        string = string.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-. ");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (Pattern.matches(alt, string2)) {
                n |= 0x200;
                continue;
            }
            if (Pattern.matches(control, string2)) {
                n |= shortcutMask;
                continue;
            }
            if (Pattern.matches(shift, string2)) {
                n |= 0x40;
                continue;
            }
            String string3 = "VK_" + string2.toUpperCase();
            try {
                n2 = KeyEvent.class.getField(string3).getInt(KeyEvent.class);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error parsing shortcut text. The offending token: " + string2);
            }
        }
        this.keyMask = n;
        this.keyCode = n2;
        this.label = new String();
        if (this.keyMask != 0) {
            string2 = KeyEvent.getModifiersExText(this.keyMask);
            if (string2.equalsIgnoreCase("command")) {
                string2 = "Cmd";
            }
            this.label = this.label + string2 + "+";
        }
        if (this.keyCode != 0) {
            this.label = this.label + KeyEvent.getKeyText(this.keyCode);
        }
    }

    public boolean matchesKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = keyEvent.getModifiersEx() == this.keyMask;
        return bl && keyEvent.getKeyCode() == this.keyCode;
    }

    public void performAction() {
        if (this.action != null) {
            this.action.performAction();
        }
    }
}

