/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.event.MouseEvent;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Label;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.UIUtils;
import processing.core.PApplet;

public class LabelHyperlink
extends Label {
    String url;
    boolean hovered;
    boolean pressed;
    UIRectangle tmpR = new UIRectangle();

    public LabelHyperlink(PApplet pApplet) {
        this(pApplet, "");
    }

    public LabelHyperlink(PApplet pApplet, String string) {
        super(pApplet, string);
        this.url = string;
        this.setColor(60, 60, 220);
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public void draw() {
        this.cache();
        Color color = this.color;
        if (this.pressed) {
            color = this.color.darker(80.0);
        }
        this.app.fill(color.getRGB());
        this.app.textFont(UIGlobals.g.getPFont());
        this.app.textSize(this.fontSize);
        this.app.smooth();
        this.app.textAlign(37);
        this.app.text(this.label, this.x, this.y);
        if (this.hovered) {
            this.app.strokeWeight(this.fontSize / 10.0f);
            this.app.stroke(color.getRGB());
            this.app.line(this.x, this.y + this.fontSize / 4.0f, this.x + this.cacheW, this.y + this.fontSize / 10.0f);
        }
    }

    boolean containsPoint(Point point) {
        this.cache();
        this.tmpR.setRect(this.x, this.y - this.cacheA, this.cacheW, this.cacheH);
        return this.tmpR.contains(point);
    }

    void openURL() {
        this.app.link(this.getURL(), "_new");
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        super.mouseEvent(mouseEvent, point, point2);
        if (this.containsPoint(point)) {
            if (UIUtils.getCursorOwner() == null) {
                UIUtils.setCursor(this, this.app, 12);
                this.hovered = true;
            }
            if (mouseEvent.getID() == 500) {
                this.openURL();
            } else if (mouseEvent.getID() == 501) {
                this.pressed = true;
            }
        } else {
            this.hovered = false;
            UIUtils.releaseCursor(this, this.app);
        }
        if (mouseEvent.getID() == 502) {
            this.pressed = false;
        }
    }
}

