/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.ifaces.Malleable;
import processing.core.PApplet;

public class Label
extends AbstractUIObject
implements Malleable {
    PApplet app;
    String label;
    Color color;
    float fontSize;
    float x;
    float y;
    float cacheFS;
    String cacheS;
    float cacheW;
    float cacheH;
    float cacheA;
    float cacheD;

    public Label(PApplet pApplet) {
        this.app = pApplet;
        UIGlobals.g.event().add(this);
        this.color = new Color(Color.black);
        this.label = "";
        this.fontSize = 16.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void dispose() {
        UIGlobals.g.event().remove(this);
        this.app = null;
        this.label = null;
        this.color = null;
    }

    public Label(PApplet pApplet, String string) {
        this(pApplet);
        this.setLabel(string);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void draw() {
        if (UIUtils.isJava2D(this.app)) {
            this.app.smooth();
        }
        this.app.fill(this.color.getRGB());
        this.app.textFont(UIGlobals.g.getPFont());
        this.app.textSize(this.fontSize);
        this.app.textAlign(37);
        this.app.text(this.label, this.x, this.y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
    }

    public void setPosition(float f, float f2) {
        this.setPositionByCornerNW(f, f2);
    }

    public void setPositionByBaseline(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setPositionByCornerNW(float f, float f2) {
        this.cache();
        this.x = f;
        this.y = f2 + this.cacheA;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.cache();
        this.y = f + this.cacheA;
    }

    public void setYBaseline(float f) {
        this.y = f;
    }

    public float getHeight() {
        this.cache();
        return this.cacheH;
    }

    void cache() {
        if (this.cacheS == this.label && this.cacheFS == this.fontSize) {
            return;
        }
        this.cacheS = this.label;
        this.cacheFS = this.fontSize;
        this.cacheH = UIUtils.getTextHeight(this.app.g, UIGlobals.g.getPFont(), this.fontSize, this.label, true);
        this.cacheW = UIUtils.getTextWidth(this.app.g, UIGlobals.g.getPFont(), this.fontSize, this.label, true);
        this.cacheA = UIUtils.getTextAscent(this.app.g, UIGlobals.g.getPFont(), this.fontSize, true);
        this.cacheD = UIUtils.getTextDescent(this.app.g, UIGlobals.g.getPFont(), this.fontSize, true);
    }

    public float getWidth() {
        this.cache();
        return this.cacheW;
    }

    public void setHeight(float f) {
        this.setFontSize(this.getFontSize() * f / this.getHeight());
    }

    public void setWidth(float f) {
        this.setFontSize(this.getFontSize() * f / this.getWidth());
    }

    private float getFontSize() {
        return this.fontSize;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = new Color(n, n2, n3);
    }

    public void setSize(float f, float f2) {
    }
}

