/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.andrewberman.ui.ifaces.UIObject;
import processing.core.PApplet;

public class FocusManager
implements FocusListener {
    private PApplet p;
    private Object focusedObject = null;
    private Object lostFocusHolder = null;
    private boolean isModal = false;

    public FocusManager(PApplet pApplet) {
        this.p = pApplet;
        this.p.addFocusListener((FocusListener)this);
    }

    public boolean setFocus(Object object) {
        if (this.isModal && !this.isFocused(object)) {
            return false;
        }
        this.focusedObject = object;
        return true;
    }

    public boolean setModalFocus(Object object) {
        this.focusedObject = object;
        this.isModal = true;
        return true;
    }

    public boolean removeFromFocus(Object object) {
        if (this.focusedObject == object) {
            this.focusedObject = null;
            this.isModal = false;
            return true;
        }
        return false;
    }

    public boolean isFocused(Object object) {
        if (object == null) {
            return false;
        }
        return object == this.focusedObject;
    }

    public Object getFocusedObject() {
        return this.focusedObject;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void focusEvent(FocusEvent focusEvent) {
        if (this.focusedObject instanceof UIObject) {
            ((UIObject)this.focusedObject).focusEvent(focusEvent);
        }
        switch (focusEvent.getID()) {
            case 1005: {
                this.lostFocusHolder = this.focusedObject;
                this.focusedObject = null;
                break;
            }
            case 1004: {
                if (this.lostFocusHolder == null || this.focusedObject != null) break;
                this.focusedObject = this.lostFocusHolder;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focusEvent(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focusEvent(focusEvent);
    }
}

