/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.camera.Camera;
import org.andrewberman.ui.ifaces.UIObject;
import org.andrewberman.ui.tools.ToolManager;
import processing.core.PApplet;

public final class EventManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private PApplet p;
    private ArrayList delegates = new ArrayList(5);
    private ToolManager toolManager;
    public Camera toolCamera;
    Point screen = new Point(0.0f, 0.0f);
    Point model = new Point(0.0f, 0.0f);
    ArrayList<UIObject> delegatesToAdd = new ArrayList();

    public EventManager(PApplet pApplet) {
        this.p = pApplet;
        this.setup();
    }

    public void setup() {
        if (!this.p.g.getClass().getName().equals("processing.opengl.PGraphicsOpenGL")) {
            this.p.addMouseListener((MouseListener)this);
            this.p.addMouseMotionListener((MouseMotionListener)this);
            this.p.addMouseWheelListener((MouseWheelListener)this);
            this.p.addKeyListener((KeyListener)this);
        }
        this.p.registerDraw((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UIObject uIObject) {
        ArrayList arrayList = this.delegates;
        synchronized (arrayList) {
            this.delegates.add(uIObject);
        }
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setCamera(Camera camera) {
        this.toolCamera = camera;
    }

    public void remove(UIObject uIObject) {
        this.delegates.remove(uIObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        ArrayList arrayList = this.delegates;
        synchronized (arrayList) {
            for (int i = 0; i < this.delegates.size(); ++i) {
                UIObject uIObject = (UIObject)this.delegates.get(i);
                uIObject.draw();
            }
        }
        if (this.toolManager != null) {
            this.toolManager.draw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseEvent(MouseEvent mouseEvent) {
        Object object;
        this.screen.setLocation(mouseEvent.getX(), mouseEvent.getY());
        this.model.setLocation(this.screen.x, this.screen.y);
        UIUtils.screenToModel(this.model);
        if (UIGlobals.g.focus() != null) {
            if (UIGlobals.g.focus().getFocusedObject() instanceof UIObject) {
                object = (UIObject)UIGlobals.g.focus().getFocusedObject();
                object.mouseEvent(mouseEvent, this.screen, this.model);
            }
            if (UIGlobals.g.focus().isModal()) {
                return;
            }
        }
        if (!mouseEvent.isConsumed() && this.toolManager != null) {
            this.toolManager.mouseEvent(mouseEvent, this.screen, this.model);
        }
        object = this.delegates;
        synchronized (object) {
            for (int i = this.delegates.size() - 1; i >= 0 && !mouseEvent.isConsumed(); --i) {
                UIObject uIObject = (UIObject)this.delegates.get(i);
                if (uIObject == UIGlobals.g.focus().getFocusedObject()) continue;
                uIObject.mouseEvent(mouseEvent, this.screen, this.model);
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (UIGlobals.g.focus().getFocusedObject() instanceof UIObject) {
            ((UIObject)UIGlobals.g.focus().getFocusedObject()).keyEvent(keyEvent);
        }
        if (UIGlobals.g.focus().getFocusedObject() == null && this.toolManager != null) {
            this.toolManager.keyEvent(keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEvent(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseEvent(mouseWheelEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }
}

