/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui;

import java.util.ArrayList;

public class Blinker
extends Thread {
    public static Blinker instance;
    private int delay;
    public boolean isOn;
    public boolean interrupted;
    private ArrayList listeners;

    private Blinker(int n) {
        this.delay = n;
        this.listeners = new ArrayList(1);
        this.isOn = true;
        this.interrupted = false;
    }

    public static void lazyLoad() {
        if (instance == null || !instance.isAlive()) {
            instance = new Blinker(750);
            instance.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Blinker blinker = this;
                synchronized (blinker) {
                    if (!this.interrupted) {
                        this.setState(!this.isOn);
                    } else {
                        this.interrupted = false;
                    }
                    this.wait(this.delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        Blinker.yield();
    }

    public synchronized void setState(boolean bl) {
        if (bl == this.isOn) {
            return;
        }
        this.isOn = bl;
        this.notifyListeners();
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            BlinkListener blinkListener = (BlinkListener)this.listeners.get(i);
            blinkListener.onBlink(this);
        }
    }

    public void addBlinkListener(BlinkListener blinkListener) {
        this.listeners.add(blinkListener);
    }

    public void removeBlinkListener(BlinkListener blinkListener) {
        this.listeners.remove(blinkListener);
    }

    public synchronized void reset() {
        this.setState(true);
        this.interrupted = true;
        this.notifyAll();
    }

    static interface BlinkListener {
        public void onBlink(Blinker var1);
    }
}

