/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.sortedlist;

import java.util.HashMap;
import org.andrewberman.sortedlist.ItemI;

public final class SortedItemList {
    public static final int STARTING_SIZE = 10;
    public static final Integer[] integers = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
    protected ItemI[] items;
    protected int maxIndex;
    protected int what = 0;
    protected int mult = 1;
    private int n;

    public SortedItemList() {
        this(new ItemI[10]);
        this.maxIndex = -1;
    }

    public SortedItemList(ItemI[] itemIArray) {
        this.items = itemIArray;
        this.maxIndex = itemIArray.length - 1;
    }

    public void printItems() {
        for (int i = 0; i <= this.maxIndex; ++i) {
        }
    }

    public void insert(ItemI itemI) {
        this.insert(itemI, true);
    }

    public synchronized void insert(ItemI itemI, boolean bl) {
        ++this.maxIndex;
        if (this.maxIndex >= this.items.length) {
            ItemI[] itemIArray = new ItemI[this.items.length << 2];
            System.arraycopy(this.items, 0, itemIArray, 0, this.items.length);
            this.items = itemIArray;
        }
        this.items[this.maxIndex] = itemI;
        if (bl) {
            this.sort();
        }
    }

    public synchronized void delete(ItemI itemI, boolean bl) {
        ItemI itemI2;
        for (int i = 0; i <= this.maxIndex && (itemI2 = this.items[i]) != itemI; ++i) {
        }
        this.items[i] = this.items[this.maxIndex];
        this.items[this.maxIndex] = null;
        --this.maxIndex;
        if (bl) {
            this.sort();
        }
    }

    public void clear() {
        this.items = new ItemI[10];
        this.maxIndex = -1;
    }

    public void markBelow(HashMap hashMap, float f) {
        int n = 0;
        int n2 = this.searchLeft(f);
        if (n2 < 0) {
            return;
        }
        this.markInRange(hashMap, n, n2);
    }

    public void markAbove(HashMap hashMap, float f) {
        int n = this.searchRight(f);
        int n2 = this.maxIndex;
        if (n > this.maxIndex) {
            return;
        }
        this.markInRange(hashMap, n, n2);
    }

    public void markInRange(HashMap hashMap, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            ItemI itemI = this.items[i];
            if (hashMap.containsKey(itemI)) {
                Integer n3 = (Integer)hashMap.get(itemI);
                if (n3 == integers[3]) {
                    hashMap.put(itemI, integers[3]);
                    continue;
                }
                hashMap.put(itemI, integers[n3 + 1]);
                continue;
            }
            hashMap.put(itemI, integers[0]);
        }
    }

    public int searchRight(float f) {
        for (int i = 0; i <= this.maxIndex; ++i) {
            if (!(this.items[i].get(this.what) * (float)this.mult > f * (float)this.mult)) continue;
            return i;
        }
        return this.maxIndex + 1;
    }

    public int searchLeft(float f) {
        for (int i = this.maxIndex; i >= 0; --i) {
            if (!(this.items[i].get(this.what) * (float)this.mult < f * (float)this.mult)) continue;
            return i;
        }
        return -1;
    }

    public void setSort(int n, int n2) {
        this.what = n;
        this.mult = n2;
    }

    public void sort() {
        this.insertionSort(0, this.maxIndex, this.what, this.mult);
    }

    public void sortFull() {
        this.heapSort();
    }

    public void swap(int n, int n2) {
        ItemI itemI = this.items[n];
        this.items[n] = this.items[n2];
        this.items[n2] = itemI;
    }

    public void heapSort() {
        this.n = this.maxIndex;
        this.buildHeap();
        while (this.n > 1) {
            --this.n;
            this.exchange(0, this.n);
            this.downHeap(0);
        }
    }

    private void buildHeap() {
        for (int i = this.items.length / 2 - 1; i >= 0; --i) {
            this.downHeap(i);
        }
    }

    private void downHeap(int n) {
        int n2 = 2 * n + 1;
        while (n2 < this.n) {
            if (n2 + 1 < this.n && this.items[n2 + 1].get(this.what) * (float)this.mult > this.items[n2].get(this.what) * (float)this.mult) {
                ++n2;
            }
            if (this.items[n].get(this.what) * (float)this.mult >= this.items[n2].get(this.what) * (float)this.mult) {
                return;
            }
            this.exchange(n, n2);
            n = n2;
            n2 = 2 * n + 1;
        }
    }

    private void exchange(int n, int n2) {
        ItemI itemI = this.items[n];
        this.items[n] = this.items[n2];
        this.items[n2] = itemI;
    }

    private void insertionSort(int n, int n2, int n3, int n4) {
        if (n < n2) {
            int n5;
            ItemI itemI;
            int n6 = (n2 - n) / 2 + n;
            this.insertionSort(n, n6, n3, n4);
            this.insertionSort(n6 + 1, n2, n3, n4);
            if (this.items[n6].get(n3) * (float)n4 > this.items[n2].get(n3) * (float)n4) {
                itemI = this.items[n6];
                for (n5 = n6; n5 < n2; ++n5) {
                    this.items[n5] = this.items[n5 + 1];
                }
                this.items[n2] = itemI;
                if (--n6 < n) {
                    return;
                }
            }
            if (this.items[n6 + 1].get(n3) * (float)n4 < this.items[n].get(n3) * (float)n4) {
                itemI = this.items[n6 + 1];
                for (n5 = n6 + 1; n5 > n; --n5) {
                    this.items[n5] = this.items[n5 - 1];
                }
                this.items[n] = itemI;
                if (++n6 > n2) {
                    return;
                }
            }
            int n7 = n6;
            while (this.items[n7].get(n3) * (float)n4 > this.items[n7 + 1].get(n3) * (float)n4) {
                ItemI itemI2 = this.items[n7];
                this.items[n7] = this.items[n7 + 1];
                n5 = n7 + 2;
                while (itemI2.get(n3) * (float)n4 > this.items[n5].get(n3) * (float)n4) {
                    this.items[n5 - 1] = this.items[n5];
                    ++n5;
                }
                this.items[n5 - 1] = itemI2;
                --n7;
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

