/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.evogame;

import java.util.ArrayList;
import java.util.HashMap;
import org.andrewberman.evogame.DragDropImage;
import org.andrewberman.evogame.EvoTreeManager;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.Toolbar;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.net.PWClipUpdater;
import org.phylowidget.net.PWTreeUpdater;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.ui.PhyloConfig;
import org.phylowidget.ui.PhyloUI;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public class EvoGameApplet
extends PhyloWidget {
    public static EvoGameApplet p;
    public static String nextMenu;
    private Toolbar next;
    String curMenu = "";

    public EvoGameApplet() {
        p = this;
    }

    public void setup() {
        this.frameRate(60.0f);
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.g;
        new UIGlobals(this);
        cfg = new PhyloConfig();
        trees = new EvoTreeManager(this);
        ui = new PhyloUI(this);
        treeUpdater = new PWTreeUpdater();
        clipUpdater = new PWClipUpdater();
        ui.setup();
        trees.setup();
        this.clearQueues();
        TreeManager.camera.nudgeTo(200.0f, 0.0f);
        TreeManager.camera.zoomTo(0.7f);
        this.unregisterDraw(UIGlobals.g.event());
        DragDropImage.nodeToImage = null;
        this.changeSetting("colorHoveredBranch", "false");
        this.changeSetting("textSize", "0.7");
        this.changeSetting("respondToMouseWheel", "false");
        this.changeSetting("suppressMessages", "true");
        if (EvoGameApplet.ui.context != null) {
            EvoGameApplet.ui.context.setGlow(false);
        }
    }

    public synchronized void changeSetting(String string, String string2) {
        if (string.equals("menus")) {
            this.curMenu = string2;
            DragDropImage.nodeToImage = null;
        }
        super.changeSetting(string, string2);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.g;
        if (pGraphicsJava2D == null) {
            return;
        }
        UIUtils.setRenderingHints((PGraphics)pGraphicsJava2D);
    }

    public synchronized void draw() {
        super.draw();
        for (MenuItem menuItem : EvoGameApplet.ui.menus) {
            menuItem.layout();
        }
    }

    public void next() {
        if (this.curMenu.equals("1.xml")) {
            this.changeSetting("menus", "2.xml");
        } else {
            this.changeSetting("menus", "1.xml");
        }
    }

    public boolean allNodesAreCorrect() {
        if (trees.getTree() == null) {
            return false;
        }
        HashMap<PhyloNode, DragDropImage> hashMap = DragDropImage.nodeToImage;
        if (hashMap == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        trees.getTree().getAll(trees.getTree().getRoot(), arrayList, null);
        int n = arrayList.size();
        if (hashMap.size() != arrayList.size()) {
            return false;
        }
        for (PhyloNode phyloNode : hashMap.keySet()) {
            DragDropImage dragDropImage = hashMap.get(phyloNode);
            if (dragDropImage.isAttachedToCorrectNode()) continue;
            return false;
        }
        return true;
    }
}

