/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.evogame;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.andrewberman.evogame.EvoGameApplet;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.tween.PropertyTween;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenQuad;
import org.phylowidget.PhyloWidget;
import org.phylowidget.tree.PhyloNode;
import processing.core.PApplet;
import processing.core.PImage;

public class DragDropImage
extends Menu {
    static int LONG = 30;
    static HashMap<PhyloNode, DragDropImage> nodeToImage;
    static int SHORT;
    static float SIZE;
    float aspectRatio;
    private float downMouseX;
    private float downMouseY;
    private float downPosX;
    private float downPosY;
    private boolean dragging;
    Followable f;
    boolean firstFrame = true;
    public float h;
    Tween hTween;
    private PImage img;
    String imgString;
    String targetNodeLabel;
    boolean isOpen = false;
    PhyloNode lastHoverTarget;
    private Rectangle2D.Float rectF = new Rectangle2D.Float();
    float SHRINK = 0.5f;
    public float w;
    Tween wTween;

    public DragDropImage(PApplet pApplet) {
        super(pApplet);
        TweenQuad tweenQuad = TweenQuad.tween;
        this.wTween = new PropertyTween(this, "w", tweenQuad, 1, this.width, this.width, SHORT);
        this.hTween = new PropertyTween(this, "h", tweenQuad, 1, this.height, this.height, SHORT);
    }

    public DragDropImage(PApplet pApplet, String string, String string2) {
        this(pApplet);
        this.setImage(string);
        this.targetNodeLabel = string2;
    }

    void attach(final PhyloNode phyloNode) {
        phyloNode.setAnnotation("img", "asdf");
        if (nodeToImage == null) {
            nodeToImage = new HashMap();
        }
        nodeToImage.put(phyloNode, this);
        this.aTween.continueTo(1.0f, SHORT);
        this.f = new Followable(phyloNode){

            public float getHeight() {
                return phyloNode.range.render.getTextSize() / DragDropImage.this.aspectRatio;
            }

            public float getWidth() {
                return phyloNode.range.render.getTextSize();
            }

            public float getX() {
                return phyloNode.getX() + phyloNode.range.render.getNodeRadius() * 1.05f + this.getWidth() / 2.0f;
            }

            public float getY() {
                return phyloNode.getY();
            }
        };
    }

    public boolean isAttachedToCorrectNode() {
        if (this.f == null) {
            return false;
        }
        PhyloNode phyloNode = (PhyloNode)this.f.o;
        return phyloNode.getLabel().toLowerCase().equals(this.targetNodeLabel);
    }

    protected boolean containsPoint(Point point) {
        float f = this.wTween.getPosition();
        float f2 = this.hTween.getPosition();
        this.rectF.setRect(this.x - f / 2.0f, this.y - f2 / 2.0f, f, f2);
        return this.rectF.contains(point);
    }

    public MenuItem create(String string) {
        return null;
    }

    void detach() {
        PhyloNode phyloNode = (PhyloNode)this.f.o;
        phyloNode.setAnnotation("img", null);
        if (nodeToImage == null) {
            nodeToImage = new HashMap();
        }
        nodeToImage.remove(phyloNode);
        this.f = null;
    }

    public synchronized void draw() {
        super.draw();
        this.wTween.update();
        this.hTween.update();
        if (this.f != null && !this.dragging) {
            this.x = this.f.getX();
            this.y = this.f.getY();
            this.wTween.continueTo(this.f.getWidth(), SHORT);
            this.hTween.continueTo(this.f.getHeight(), SHORT);
            return;
        }
        if (this.f != null && this.dragging) {
            float f = this.f.getX();
            float f2 = this.f.getY();
            double d = Math.sqrt((this.y - f2) * (this.y - f2) + (this.x - f) * (this.x - f));
            if (d > 20.0) {
                this.detach();
            }
            return;
        }
        if (this.dragging) {
            this.aTween.continueTo(0.5f, LONG);
        } else {
            this.aTween.continueTo(1.0f, LONG);
        }
        if (this.isOverTarget()) {
            this.wTween.continueTo(this.width * this.SHRINK, SHORT);
            this.hTween.continueTo(this.height * this.SHRINK, SHORT);
            PhyloNode phyloNode = this.getTarget();
            if (phyloNode != null) {
                phyloNode.setAnnotation("img", "");
            }
            this.lastHoverTarget = this.getTarget();
        } else {
            if (this.lastHoverTarget != null) {
                this.lastHoverTarget.setAnnotation("img", null);
                this.lastHoverTarget = null;
            }
            this.wTween.continueTo(this.width, SHORT);
            this.hTween.continueTo(this.height, SHORT);
        }
    }

    public void setTargetNodeLabel(String string) {
        this.targetNodeLabel = string.toLowerCase();
    }

    public synchronized void drawMyself() {
        int n = this.canvas.color(255, 0, 0);
        if (this.isAttached()) {
            int n2 = 0;
            n2 = this.isAttachedToCorrectNode() ? this.canvas.color(0, 255, 0) : this.canvas.color(255, 0, 0);
            this.canvas.rectMode(3);
            this.canvas.strokeWeight(3.0f);
            this.canvas.stroke(n2);
            this.canvas.noFill();
            this.canvas.rect(this.x, this.y, this.w, this.h);
            this.canvas.rectMode(0);
        }
        if (this.img == null) {
            this.canvas.fill(n);
            this.canvas.rect(this.x, this.y, this.w, this.h);
        } else {
            this.canvas.imageMode(3);
            this.canvas.smooth();
            this.canvas.image(this.img, this.x, this.y, this.w, this.h);
            this.canvas.noSmooth();
            this.canvas.imageMode(0);
        }
        this.canvas.noTint();
    }

    PhyloNode getTarget() {
        return EvoGameApplet.ui.getHoveredNode();
    }

    boolean isAttached() {
        return this.f != null;
    }

    public boolean isOpen() {
        return true;
    }

    boolean isOverTarget() {
        PhyloNode phyloNode = this.getTarget();
        if (phyloNode != null && this.dragging) {
            return nodeToImage == null || !nodeToImage.containsKey(phyloNode) || nodeToImage.get(phyloNode) == this;
        }
        return false;
    }

    public synchronized void layout() {
        super.layout();
        this.menu.zSort();
    }

    void recalcSize() {
        float f;
        float f2 = this.img.width;
        float f3 = this.img.height;
        if (f2 > SIZE) {
            f = SIZE / f2;
            f2 *= f;
            f3 *= f;
        }
        if (f3 > SIZE) {
            f = SIZE / f3;
            f3 *= f;
            f2 *= f;
        }
        this.aspectRatio = f2 / f3;
        this.width = f2;
        this.height = f3;
        this.wTween.continueTo(f2);
        this.hTween.continueTo(f3);
    }

    public void setImage(String string) {
        String string2 = "../../src/org/andrewberman/evogame/";
        PImage pImage = null;
        String string3 = EvoGameApplet.p.getDocumentBase().toString();
        int n = string3.lastIndexOf("/");
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        if (PhyloWidget.cfg.debug) {
            System.out.println(string3);
        }
        this.img = pImage = EvoGameApplet.p.loadImage(string3 + "/" + string);
        this.aspectRatio = (float)pImage.width / (float)pImage.height;
        this.recalcSize();
        this.wTween.fforward();
        this.hTween.fforward();
    }

    public void setTree(String string) {
        EvoGameApplet.p.changeSetting("tree", string);
    }

    public void setNextMenu(String string) {
        EvoGameApplet.nextMenu = string;
    }

    public void setOptions() {
        super.setOptions();
        this.useHandCursor = true;
        this.modalFocus = false;
        this.focusOnShow = false;
        this.consumeEvents = false;
    }

    protected void visibleMouseEvent(MouseEvent mouseEvent, Point point) {
        super.visibleMouseEvent(mouseEvent, point);
        if (mouseEvent.getID() == 502) {
            if (this.isOpen) {
                this.close();
                this.isOpen = false;
            }
            if (this.isOverTarget() && this.dragging) {
                PhyloNode phyloNode = this.getTarget();
                this.attach(phyloNode);
            }
        }
        if (mouseEvent.getID() == 501) {
            this.downMouseX = point.x;
            this.downMouseY = point.y;
            this.downPosX = point.x;
            this.downPosY = point.y;
            if (this.mouseInside) {
                this.open();
                this.isOpen = true;
                mouseEvent.consume();
            }
        }
        if (!this.mouseInside && !this.dragging) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            if (this.isOpen) {
                this.dragging = true;
                float f = point.x - this.downMouseX;
                float f2 = point.y - this.downMouseY;
                this.setPosition(this.downPosX + f, this.downPosY + f2);
            }
        } else {
            this.dragging = false;
        }
    }

    static {
        SHORT = 15;
        SIZE = 128.0f;
    }

    abstract class Followable {
        Object o;

        public Followable(Object object) {
            this.o = object;
        }

        public abstract float getHeight();

        public abstract float getWidth();

        public abstract float getX();

        public abstract float getY();
    }
}

