<?xml version="1.0" encoding="utf-8"?>
<!-- 
	form_parameters.xsl stylesheet
	Authors: Hervé Ménager
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml">
	
	<xsl:include href="ident.xsl" />

	<xsl:param name="jobUrl" />
	
	<xsl:template match="parameters">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" />
			<xsl:if test="(/program) and not(ancestor::paragraph)">
				<!-- Adding stdout parameter if not specified in the program description -->
				<parameter isstdout="true">
					<name>stdout</name>
					<type>
						<datatype>
							<class>Report</class>
						</datatype>
					</type>
					<interface type="job_output" generated="true">
						<xhtml:div data-parametername="stdout">
							<xhtml:span class="prompt">Standard output</xhtml:span>
						</xhtml:div>
					</interface>
				</parameter>
			</xsl:if>
			<!-- Adding stderr parameter -->
			<xsl:if test="(/program) and not(ancestor::paragraph)">
				<parameter isout="true">
					<name>stderr</name>
					<type>
						<datatype>
							<class>Report</class>
						</datatype>
					</type>
					<interface type="job_output" generated="true">
						<xhtml:div class="prompt" data-parametername="stderr">
							<xhtml:span class="prompt">Standard error</xhtml:span>
						</xhtml:div>
					</interface>
				</parameter>
			</xsl:if>
		</xsl:copy>
	</xsl:template>	

	<xsl:template match="parameter">
		<xsl:if test="not(interface[@type='job_input' or @type='job_output'])">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()" />
				<interface generated="true">
					<xsl:attribute name="type">
						<xsl:choose>
							<xsl:when test="@isout or @isstdout">job_output</xsl:when>
							<xsl:otherwise>job_input</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xhtml:div data-parametername="{name/text()}">
						<xhtml:span class="prompt"><xsl:value-of select="prompt/text()" /></xhtml:span>
					</xhtml:div>
				</interface>
			</xsl:copy>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>