#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import os
import mb_cgi
import Mobyle.MobyleJob 
from Mobyle.MobyleError import MobyleError
from Mobyle.Registry import registry

def process(self):
    # program exists on the Server
    try:
        if self.request.has_key('url'):
            self.jobUrl = self.request.getfirst('url')
        else:
            self.error_title = "No job requested."
            self.error_msg = "The job url or id has not been specified"
            return
        self.jobPID = self.request.getfirst('pid')
        ownersList = self.jobPID.split('::')
        ownerPortals = [pid.split('.')[0] for pid in ownersList if len(pid.split('.'))==3]
        self.job = Mobyle.MobyleJob.MobyleJob(ID=self.jobUrl)
        jobName = self.job.jobState.getName().split('/')[-1][:-4]
        if len(ownerPortals)>0:
            jobName += '@'+ownerPortals.pop()
        self.title = "%s - %s" % (jobName, self.job.jobState.getDate())
    except Exception,err:
        mb_cgi.c_log.error(err)
        if self.jobPID:
            self.error_title = "Job not found."
            self.error_msg = "The job %s cannot not be found on this server." % self.jobPID
        else:
            self.error_title = "Job error."
            self.error_msg = "Error."
        return
    self.xmlUrl = self.job.getJobid()+'/index.xml'
    isIE = (os.environ.get("HTTP_USER_AGENT", "unknown").find("MSIE")!=-1)
    self.xslPipe = [
                    (self.cfg.portal_path()+"/xsl/job.xsl",
                        {'jobPID':"'"+self.jobPID+"'",
                         'previewDataLimit':"'"+str(self.cfg.previewDataLimit())+"'",
                         'isIE':"'"+str(isIE)+"'"
                         }),
                    (self.cfg.portal_path()+"/xsl/remove_ns.xsl",{}) # remove xhtml namespace junk
                    ]
    

if __name__ == "__main__":
    il = mb_cgi.XSLCGI(processFunction=process)