#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import time
from Mobyle.Registry import registry

def get_formatted_job_entries(job):
    if job['date']:
        jobdatestring = time.strftime( "%x    %H:%M", job['date'])
        jobsortdate = time.strftime( "%Y%m%d%H%M%S", job['date'])
    else:
        jobdatestring = '?'
        jobsortdate = '?'
    job['status_message'] = ""
    if hasattr(job['status'], 'message'):
        job['status_message'] = job['status'].message
    job['status'] = str(job['status'])
    job['jobID'] = registry.getJobPID(job['jobID'])
    l = job['jobID'].split('.')
    if len(l)==2:
        server_name='local'
    else:
        server_name= l[0]
    values = {'server':server_name,
                         'programName': job['programName'] ,
                         'jobDate': jobdatestring ,
                         'jobSortDate':jobsortdate,
                         'status':job['status'] ,
                         'status_message':job['status_message'],
                         'dataUsed': job.get('dataUsed')}
    if job.has_key('owner'):
        values['owner'] = registry.getJobPID(job['owner'])
    dict = {job['jobID']:values}
    if job.has_key('subjobs') and job['subjobs'] is not None:
        for subjob in job['subjobs']:
            subdict = get_formatted_job_entries(subjob)
            dict.update(subdict)
    return dict
    
def process( self ):
    jobsMap = {}
    dataMap = {}
    if self.session:
        tmpjobs = self.session.getAllJobs()
        jobsMap = {}
        for job in tmpjobs:
            dict = get_formatted_job_entries(job)
            jobsMap.update(dict)
        data = self.session.getAllData()
        for dataFile in data:
            dataType = dataFile['Type'].getDataType().name
            bioTypes = []
            for bt in dataFile['Type'].getBioTypes():
                bioTypes.append(str(bt))
            userModes = []
            for im in dataFile['inputModes']:
                userModes.append(im)
            format = dataFile['Type'].getDataFormat()
            dataMap[dataFile['dataName']] = {'userName':dataFile['userName'], 'dataType': dataType, 'bioTypes': bioTypes, 'userModes': userModes, 'title':dataFile['dataBegin'], 'size': '%.2f'%(float(dataFile['size'])/1000), 'format': format}
    self.jsonMap = {'jobs': jobsMap, 'data': dataMap}

if __name__ == "__main__":
    mb_cgi.JSONCGI(processFunction=process,useSession=True)