#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.MobyleJob 
from Mobyle.MobyleError import MobyleError
from Mobyle.Registry import registry

def process(self):
    # program exists on the Server
    try:
        self.jobID = registry.getJobURL(self.request.getfirst('id'))
        self.jobPID = registry.getJobPID(self.jobID)
        self.job = Mobyle.MobyleJob.MobyleJob(ID=self.jobID)
        self.title = "%s - %s" % (self.job.jobState.getName().split('/')[-1][:-4], self.job.jobState.getDate())
    except MobyleError:
        if self.jobPID:
            self.error_title = "Job not found."
            self.error_msg = "The job %s cannot not be found on this server." % self.jobPID
        else:
            self.error_title = "Job error."
            self.error_msg = "Error."
        return
    self.xmlUrl = self.job.getJobid()+'/index.xml'
    self.xslPipe = [
                    (self.cfg.portal_path()+"/xsl/job.xsl",
                        {'jobPID':"'"+self.jobPID+"'",
                         'previewDataLimit':"'"+str(self.cfg.previewDataLimit())+"'"}),
                    (self.cfg.portal_path()+"/xsl/remove_ns.xsl",{}) # remove xhtml namespace junk
                    ]
    

if __name__ == "__main__":
    il = mb_cgi.XSLCGI(processFunction=process)