#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.Registry import registry

def process(self):
    self.programUrl = self.request.getfirst('programUrl')
    if not registry.programsByUrl.has_key(self.programUrl) and \
        registry.programsByUrl.has_key(registry.getProgramUrl(self.programUrl)):
        self.programUrl = registry.getProgramUrl(self.programUrl)
    if self.request.has_key('isInPortal'):
        self.isInPortal = self.request.getfirst('isInPortal')
    else:
        self.isInPortal='false'
    self.xslParams = {u'isInPortal': unicode(self.isInPortal),u'optEmail':unicode(self.cfg.opt_email(self.programUrl)),u'errorMsg':u"",u'programUri':self.programUrl}
    try:
        program = registry.programsByUrl[self.programUrl]
        if not(program.server.name=='local'):
            self.xslParams['remoteServerName']=program.server.name
    except KeyError, ke:
        # program does not exist
        self.error_msg = "this program is not available on this server"
        self.error_title = self.programUrl
        return
    if program.disabled:
        # program disabled
        self.error_msg = "this program has been disabled on this server"
        self.error_title = program.name
    elif not(program.authorized):
        # program restricted
        self.error_msg = "the access to this program is restricted on this server"
        self.error_title = program.name
    else:
        # ok
        self.xmlUrl = program.path
        self.xsltUri = self.cfg.portal_path()+"/xsl/form.xsl" #FIXME should be a local path not a www uri

if __name__ == "__main__":
    il = mb_cgi.XSLCGI(processFunction=process)