#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.ConfigManager
import urllib # module used to encode the anchors in the menu html page
from Mobyle.Registry import registry
from Mobyle.ClassificationIndex import ClassificationIndex
from Mobyle.SearchIndex import SearchIndex
from Mobyle.DescriptionsIndex import DescriptionsIndex


def process(self):
    self.template_file = "programs_list.html"
    isInPortal = self.request.getfirst('isInPortal', 'false')
    self.response['sortBy'] = self.request.getfirst('sortBy', 'server')
    self.response['filterOn'] = 'false'
    self.response['emptySearchResults'] = 'false'

    if self.request.getfirst('plSubmit')=='Search':
        searchString = self.request.getfirst('searchString',None)
        if searchString:
            si = SearchIndex()
            self.response['filterOn'] = 'true'
            si.filterRegistry(searchString.split(' '))
        if len(registry.programs)==0:
            self.response['emptySearchResults'] = 'true'

    classification = ClassificationIndex()
    DescriptionsIndex().fillRegistry()
    classification.buildRegistryCategories()
    self.response['registry']=registry
      
if __name__ == "__main__":
    mb_cgi.TALCGI(processFunction=process)