#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import os
import Mobyle.ConfigManager
from Mobyle.Registry import registry
from Mobyle.JobFacade import JobFacade
from Mobyle.MobyleError import MobyleError


def process(self):
    self.template_file = 'portal.html'
    if self.session:
        self.response['authenticated'] = self.session.isAuthenticated()
        self.response['activated'] = self.session.isActivated()
        actkey = self.request.getfirst('actkey')
        if actkey:
            self.response['actkey'] = actkey
    else:
        self.response['sessionId'] = None
        self.response['authenticated'] = False
        self.response['activated'] = False
    self.response['anonymousSession'] = (self.cfg.anonymousSession()!='no')
    self.response['authenticatedSession'] = (self.cfg.authenticatedSession()!='no')
    self.response['sessionLimit']='%.2f'%(float(self.cfg.sessionlimit())/1000)
    self.response['refresh_frequency']=self.cfg.refreshFrequency()
    self.response['messages'] = []
    openedForms=','.join(self.request.getlist('form')+self.request.getlist('forms'))
    if openedForms:
        # here, if any pre-loaded form is requested, try to identify it by
        # its url or get its url as a local program to avoid breaking
        # external links
        formUrls = openedForms.split(',')
        from Mobyle.DescriptionsIndex import DescriptionsIndex
        DescriptionsIndex().fillRegistry()
        self.response['openedForms'] = []
        self.response['openedFormNames'] = []
        self.response['openedFormParameters'] = []
        self.response['descriptionElements'] = []
        for url in formUrls:
            oUrl = url
            if not registry.programsByUrl.has_key(url) and \
                registry.programsByUrl.has_key(registry.getProgramUrl(url)):
                url = registry.getProgramUrl(url)
            program = registry.programsByUrl.get(url,None)
            self.response['openedForms'].append(url)
            if program:
                self.response['openedFormNames'].append(program.name)
                self.response['descriptionElements'].append(program.name + ': ' + program.description + '.')
            else:
                self.response['openedFormNames'].append('?')                    
            # it is possible to ask for specific preloaded values in the form
            for name in self.request.keys():
                if name.startswith(oUrl+'_'):
                    self.response['openedFormParameters'].append((name.replace(oUrl+'_',url+'_'),self.request.getfirst(name)))
    openedJobs=self.request.getfirst('jobs')
    if openedJobs:
        jobIdsList = openedJobs.split(',')
        normalizedJobIdsList = []
        for jobId in jobIdsList:
            try:
                j = JobFacade.getFromJobId(jobId)
                normalizedJobIdsList.append(j.jobId)
                if not(self.session.hasJob(jobId)):
                    self.session.addJob(jobId)
            except MobyleError, me:
                self.response['messages'].append('Job %s cannot be found on this server.' % jobId)
                pass
        openedJobs = normalizedJobIdsList
        self.response['openedJobs'] = openedJobs
    annFileName = os.path.normpath(os.path.join( self.cfg.portal_path(),"html/announcement.txt"))
    self.cssDir = '/'+self.cfg.portal_url(True)+"/css/"
    self.jsDir = '/'+self.cfg.portal_url(True)+"/js/"
    self.htDir = '/'+self.cfg.portal_url(True)+"/"
    if os.path.isfile(annFileName):
        templateCacheFile = open (annFileName,'r')
        self.response['announcement'] = templateCacheFile.read()
        templateCacheFile.close()

if __name__ == "__main__":
    mb_cgi.TALCGI(processFunction=process,useSession=True)
