#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.MobyleJob 
from Mobyle.MobyleError import *
from Mobyle.Registry import registry

def process(self):
    # program exists on the Server
    try:
        self.job = Mobyle.MobyleJob.MobyleJob(ID=self.request.getfirst('jobid'))
        self.progFileName = registry.programsByUrl[self.job.jobState.getName()].path
    except MobyleError, me:
        self.error_msg = "This job does not exist."
        self.progFileName = ""
        return
    self.xmlUrl = self.job.getJobid()+'/index.xml'
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',\
                      u'serviceXmlUri': self.progFileName,\
                      u'previewDataLimit':self.cfg.previewDataLimit(),}
    self.xsltUri = self.cfg.portal_path()+'/xsl/job.xsl'

if __name__ == "__main__":
    il = mb_cgi.XSLCGI(processFunction=process)