<?xml version="1.0" encoding="UTF-8"?>
<!-- This is a validating schematron file for the mobyle program				-->
<!-- definitions, heavily inspired by existing python-based         			-->
<!-- validators from Bertrand Néron and Nicolas Joly 							-->
<!--                                                							-->
<!-- Author: Hervé Ménager					             						-->
<!-- 'Biological Software and Databases' Group, Institut Pasteur, Paris.  		-->
<!-- Distributed under LGPLv2 Licence. Please refer to the COPYING.LIB document.-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" >
     <value-of select="$documentName"/>
     <pattern name="Check program">
          <rule context="program">
       	   	   <let name="commandElementsCount" value="./head/command"/>
       	   	   <let name="iscommandParametersCount" value="count(.//parameter[@iscommand='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
       	   	   <let name="stdoutParametersCount" value="count(.//parameter[@isstdout='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
       	   	   <let name="stderrParametersCount" value="count(.//parameter[@isstderr='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
               <assert test="not(count(.//parameter[@iscommand='1'])=1 and $commandElementsCount=1)">
               A program cannot contain both a command element and an iscommand parameter
               </assert>
               <assert test="not($iscommandParametersCount=0 and $commandElementsCount=0)">
               A program has to contain one command element or one iscommand parameter:
               (<value-of select="$iscommandParametersCount"/> iscommand parameters, 
               <value-of select="$commandElementsCount"/> command elements)
               </assert>
               <assert test="$iscommandParametersCount &lt;= 1">
               	Only one parameter can be iscommand if no precond specified (current number in document: <value-of select="$iscommandParametersCount"/>)
               </assert>
               <assert test="$stdoutParametersCount &lt;= 1">
               	Only one parameter can link to standard output if no precond specified (current number in document: <value-of select="$stdoutParametersCount"/>)
               </assert>
               <assert test="$stderrParametersCount &lt;= 1">
               	Only one parameter can link to standard error if no precond specified (current number in document: <value-of select="$stderrParametersCount"/>)
               </assert>
          </rule>
          <rule context="parameter[@isout='1']">
          	   <let name="parameterName" value="name"/>
               <assert test="count(filenames) &gt; 0">
               Invalid parameter: <value-of select="$parameterName"/>: an isout parameter must include a filename 
               </assert>
          </rule>
          <rule context="parameter[((not(@isout)) or (@isout='0')) and ((not(@isstdout)) or (@isstdout='0')) and ((not(@isstderr)) or (@isstderr='0'))]">
          	   <let name="parameterName" value="name"/>
               <assert test="count(filenames) = 0">
               Invalid parameter: <value-of select="$parameterName"/>: an input parameter cannot include a filename 
               </assert>
          </rule>
          <rule context="parameter/type/datatype/class">
          	   <let name="parameterName" value="../../../name"/>
          	   <assert test="not(starts-with(text(),'Abstract'))">
          	   Invalid parameter datatype class for parameter '<value-of select="$parameterName"/>': no parameter datatype class can be abstract.
          	   </assert>
          </rule>
          
     </pattern>
</schema>