#include <Python.h>
#include <signal.h>


static PyObject * python_siginterrupt(PyObject *self, PyObject *args){
    
    int sigint , flag ,rc ;



    if (! PyArg_ParseTuple(args , "ii" , &sigint , &flag) ) {
	PyErr_SetString( PyExc_TypeError, "siginterrupt takes 2 int as args");
	return NULL ;
    }
	
 
    if ( !(flag == 0 || flag == 1) ){
	PyErr_SetString( PyExc_TypeError, "flag must be a boolean");
	return NULL ;
    }

    rc = siginterrupt( sigint , flag );
    
    if ( rc == -1 ){
	PyErr_SetFromErrno( PyExc_OSError );
	return NULL;
	    }


    return Py_BuildValue("i", rc);
}


static PyMethodDef siginterruptFnct[] = {
    {"siginterrupt" , python_siginterrupt , METH_VARARGS, "The  siginterrupt()  function  changes  the  restart behaviour when a system call is\ninterrupted by the signal sig.  If the flag argument is false (0), then system calls\nwill  be  restarted if interrupted by the specified signal sig.  This is the default\nbehaviour in Linux.  However, when a new signal handler is specified with  the  sig-\nnal(2) function, the system call is interrupted by default.\n\nIf  the  flags  argument is true (1) and no data has been transferred, then a system\ncall interrupted by the signal sig will return -1 and the global variable errno will\nbe set to EINTR.\n\nIf  the  flags  argument  is true (1) and data transfer has started, then the system\ncall will be interrupted and will return the actual amount of data transferred.\n"} ,
    {NULL ,NULL ,0,NULL }
} ;


PyMODINIT_FUNC initsiginterrupt(void) {
    (void) Py_InitModule("siginterrupt" , siginterruptFnct ) ;
}

