#! /usr/bin/env python

import os.path
import sys
import Ft.Xml.Domlette

for file in sys.argv[1:] :
  uri = "file://"+os.path.abspath(file)
  file = os.path.basename(file)
  try:
    xml = Ft.Xml.Domlette.ValidatingReader.parseUri(uri)
  except Exception, err:
    print "%s: xml does not validate: %s" % (file, err)
    continue

  # Header name must be identical to file name
  name = xml.xpath('/program/head/name/text()')
  if name[0].data+".xml" != file :
    print "%s: wrong header name" % file

  # Duplicate parameter/paragraph names
  paras = xml.xpath('//parameter/name/text() | //paragraph/name/text()')
  names = [ par.data for par in paras ]
  names.sort(cmp)
  for nam in names :
    if names.count(nam) < 2 : continue
    print "%s: %s: duplicate name" % (file, nam)

  # Multiple iscommand/isstdout parameters
  icmds = xml.xpath('//parameter[@iscommand=1]')
  if icmds and len(icmds) > 1 :
    print "%s: unexpected duplicated iscommand" % file

  # Redundant command/iscommand
  cmd = xml.xpath('/program/head/command')
  if icmds and cmd :
    print "%s: unexpected command/iscommand" % file

  ## Parameter specific checks
  params = xml.xpath('//parameter')
  for par in params :

    # Mandatory parameters name/class
    name = par.xpath('name/text()')[0].data
    clas = par.xpath('type/datatype/class/text()')[0].data

    # Not allowed class types
    if clas in [ "AbstractText" ] :
      print "%s: %s: unexpected class" % (file, name)

    ## FIXME: Most parameter attributes must have a 0/1 value

    # Output parameters
    out1 = par.xpath('@isout=1')
    out2 = par.xpath('@isstdout=1')
    out = out1 or out2

    # No input parameter should be of type Text
    if not out and clas in [ "Text" ] :
      print "%s: %s: suspicious text class" % (file, name)

    # Parameter should not set both isout and isstdout at the same time
    if out1 and out2 :
      print "%s: %s: unneeded isout+isstdout" % (file, name)

    # Hidden input parameters must be of type String
    hid = par.xpath('@ishidden=1')
    if not out and hid and clas in [ "Text" ] :
      print "%s: %s: unexpected hidden param class" % (file, name)

    ## FIXME: card syntax must be either 1/1,2/1,n

    # Mandatory attribute
    man = par.xpath('@ismandatory=1')

    # acceptedDataFormats is restricted to Sequence/Alignment
    fmts = par.xpath('type/acceptedDataFormats')
    if fmts and not clas in [ "Sequence", "Alignment" ] :
      print "%s: %s: unexpected data format" % (file, name)
    if not fmts and not out and clas in [ "Sequence", "Alignment" ] :
      print "%s: %s: no data format specified" % (file, name)

    # vdefs checks
    vdefs = par.xpath('vdef/value/text()')
    vdefv = [ vdef.data for vdef in vdefs ]

    # Mandatory vdef
    if not vdefs and clas in [ "Boolean", "Choice", "MultipleChoice" ] :
      print "%s: %s: missing vdef" % (file, name)
    if not vdefs and hid and man :
      print "%s: %s: missing vdef" % (file, name)
    # Unexpected vdef     ... FIXME: Infile
    if vdefs and not out and clas in [] :
      print "%s: %s: unexpected vdef" % (file, name)

    # Only MultipleChoice can have multiple vdef values
    if len(vdefs) > 1 and clas != "MultipleChoice" :
      print "%s: %s: unexpected extra vdef values" % (file, name)

    # Lists checks
    vlist = par.xpath('vlist')
    flist = par.xpath('flist')
    lvals = par.xpath('vlist/velem/value/text() | flist/felem/value/text()')
    lvalv = [ lval.data for lval in lvals ]
    llabs = par.xpath('vlist/velem/label/text() | flist/felem/label/text()')
    llabv = [ llab.data for llab in llabs ]

    # Cannot have both vlist and flist altogether
    if vlist and flist :
      print "%s: %s: unexpected vlist+flist" % (file, name)

    # vdefs must be in vlist/flist allowed values
    for vdef in vdefv :
      if not lvalv or vdef in lvalv : continue
      print "%s: %s: invalid vdef value" % (file, name)

    # vlist/flist must have only 1 active undef
    undef = par.xpath('vlist/velem[@undef=1] | flist/felem[@undef=1]')
    if undef and len(undef) > 1 :
      print "%s: %s: unexpected extra undef" % (file, name)

    # Duplicate value/label in vlist/flist
    for lval in lvalv :
      if lvalv.count(lval) < 2 : continue
      print "%s: %s: duplicate list value" % (file, name)
    for llab in llabv :
      if llabv.count(llab) < 2 : continue
      print "%s: %s: duplicate list label" % (file, name)

    sep = par.xpath('separator')
    # Mandatory separator
    if not sep and clas == "MultipleChoice" :
      print "%s: %s: missing separator" % (file, name)
    # Unexpected separator
    if sep and clas != "MultipleChoice" :
      print "%s: %s: unexpected separator" % (file, name)

    # FIXME: Empty separator && value length >1
    for lval in lvalv :
      if not sep : continue
      if len(lval) < 2 : continue

    ## FIXME: Missing/Extra proglang

    fnam = par.xpath('filenames')
    # Mandatory filenames
    if not fnam and out :
      print "%s: %s: missing filenames" % (file, name)
    # Unexpected filenames
    if fnam and not out :
      print "%s: %s: unexpected filenames" % (file, name)

    ## FIXME: isout parameter + filename `program.out'

