#! /usr/bin/env python

import os
import sys 
import Ft.Xml.Domlette

try:
    _MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME']= "/home/bneron/Mobyle"
    _MOBYLEHOME = os.environ['MOBYLEHOME']


if (os.path.join(_MOBYLEHOME,'Src')) not in sys.path:    
    sys.path.append(os.path.join(_MOBYLEHOME,'Src'))
    
from Mobyle import  Parser



def uniq( l ):
    """
    @param l: the list to sort
    @type l: list of hashable object
    @return: a list sorted and each element is uniq
    @rtype: list 
    """
    u = {}
    for item in l:
        u[ item ] = 1
    x = u.keys()
    x.sort()
    return x

## main ##
_error = False

for path in sys.argv[ 1 : ]:
    path = os.path.abspath( path )
    print >> sys.stdout , "\n\n-------------------- validating " + path +" --------------------"
    
    try:
        uri = "file://" + path
        #doc = Ft.Xml.Domlette.NonvalidatingReader.parseUri( uri )
        doc = Ft.Xml.Domlette.ValidatingReader.parseUri( uri )
    except Ft.Lib.UriException , err :
        print >> sys.stdout , "enable to parse " + uri +" : \n"+ str( err )
        continue
    except Ft.Xml.ReaderException ,err :
        print >> sys.stdout , "invalid document :\n" + str( err )
        continue
    
    
    #tester si deux paramettres ou deux paragraphes ont le meme nom
    parametersName = [ name.data for name in doc.xpath( '//parameter/name/text()') ]
    for i in range( len( parametersName ) ):
        if parametersName[ i ] in parametersName[ i+1 : ]:
            print >> sys.stdout , "2 parameters have the same name :" + parametersName[ i ]
            _error = True
            
    paragraphsName = [ name.data for name in doc.xpath( '//paragraph/name/text()') ]
    for i in range( len( paragraphsName ) ):
        if paragraphsName[ i ] in paragraphsName[ i+1 : ]:
            print >> sys.stdout , "2 paragraphs have the same name : "+ paragraphsName[ i ]
            _error = True
            
    for param in parametersName:
        if param in paragraphsName:
          print >> sys.stdout , "1 parameter and 1 paragraph have the same name : " + param  
          _error = True
    
    
    #teste si plusieurs parametre iscommand
    parameterCommand = [ name.data for name in doc.xpath( '//parameter[@iscommand = "1" ]/name/text()') ]
    
    if len( parameterCommand ) > 1 :
        print >> sys.stdout , "these "+ str( parameterCommand ) +" parameters have attribute iscommand=\"1\" only 1 is allowed"
        _error = True
            
    #test si comamnd + parameter iscommand
    command = doc.xpath( './program/head/command')
    if parameterCommand and command:
        print >> sys.stdout , "the command is specified by the element command and with parameter \""+ doc.xpath('//parameter[@iscommand = "1" ]/name/text()')[0].data +"\" which have attribute iscommand=\"1\". you can't specify both"
        _error = True
        
    #un paramettre isout sans filename
    isoutParams = doc.xpath('//parameter[@isout = "1"]')
    isoutParams += doc.xpath('//parameter[@isstdout = "1"]')
    
    for paramNode in isoutParams:
        #un paramettre isout doit avoir un element filename
        if not paramNode.xpath( './filenames'):
            print >> sys.stdout , "the parameter \"%s\" have an attribute isout or isstdout=\"1\" but haven't filenames element" % paramNode.xpath('./name/text()')[0].data
            _error = True
            
    # paramettre input ne doit pas avoir d'element filenames 
    paramNodes = doc.xpath( '//parameter[filenames]')
    for paramNode in paramNodes:
        try:
            out = int( paramNode.xpath('@isout')[0].value )
        except IndexError:
            try:
                out = int( paramNode.xpath('@isstdout')[0].value )
            except IndexError:
                out = 0
        if not out:
            print >> sys.stdout , "the parameter \"%s\" have a filenames element but haven't attribute isout=\"1\"" %paramNode.xpath('name/text()')[0].data
            _error = True
    
    #2 paramettres isstdout
    sdoutparams= doc.xpath( '//parameter[@isstdout ="1"]')
    if len( sdoutparams ) > 1:
        paramsName = [ name.xpath( 'name/text()')[0].data for name in sdoutparams ]
        print >> sys.stdout , "there is %i parameter %s with attribute isstdout=\"1\" . Only 1 is allowed" %( len( sdoutparams ) ,
                                                                                                              paramsName
                                                                                                              )
        _error = True
        
    #si toutes les balises codes ont les memes proglang
    allCodes = doc.xpath( '//code' )
    try:
        prgLangRef = uniq( [ prgLang.value for prgLang in allCodes[0].parentNode.xpath( './code/@proglang' ) ] )
    except IndexError:
        pass #il n'y a aucune balise code ???
    else:
        for code in allCodes:
            proglangs = uniq( [ prgLang.value for prgLang in code.parentNode.xpath( './code/@proglang') ] )
            
            if proglangs != prgLangRef:
                element = code.parentNode.nodeName
               
                if element == "felem":
                    paraType = code.parentNode.parentNode.parentNode.nodeName
                    try:
                        paraName = code.parentNode.parentNode.parentNode.xpath('./name/text()' )[0].data
                    except IndexError:
                        print >> sys.stderr , "invalid xml , please validate your xml before"
                        _error = True
                else:
                    paraType = code.parentNode.parentNode.nodeName
                    try:
                        paraName = code.parentNode.parentNode.xpath('./name/text()' )[0].data
                    except IndexError:
                        print >> sys.stderr , "invalid xml , please validate your xml before"
                        _error = True
                print >> sys.stdout ,"the %s named \"%s\" have an element \"%s\" which have inconsistance code proglangs : %s , compare to proglangs ref : %s" %( paraType ,paraName  , element   , proglangs , prgLangRef )                      
                _error = True
    
    #pas de vdef dans les infile?                        
        
    #vdef doit appartenir vlist ou flist
    for vdefNode in doc.xpath( '//vdef' ) :
        myList =[ v.data for v in  vdefNode.parentNode.xpath( 'vlist/velem/value/text()' ) ]   #list des values de la vlist
        listType = 'vlist'
        
        if not myList:
            myList =[ v.data for v in  vdefNode.parentNode.xpath( 'flist/felem/value/text()' ) ]
            listType = 'flist'
            if not myList:
                continue #pas de flist ni de vlist
            
        vdef = [ v.data for v in vdefNode.xpath('value/text()') ]
        for oneVdef in vdef:
            if oneVdef not in myList:
                paramName = vdefNode.parentNode.xpath('name/text()')[0].data
                print >> sys.stdout ,"the parameter named \"%s\" have a vdef value \"%s\" which is not in  %s " %( paramName  , 
                                                                                                                 oneVdef ,
                                                                                                                 listType ,
                                                                                                                )   
                _error = True                   


    #tous les param avec vlist ou flist doivent avoir une vdef ainsi que les parametres de types boolean
    paramVlist = doc.xpath( "//parameter[vlist]" )
    paramFlist = doc.xpath( "//parameter[flist]" )
    paramBoolean = doc.xpath( '//parameter[type/datatype/class = "Boolean" ]' )
    paramList = []
    paramList += paramVlist
    paramList += paramFlist  
    paramList += paramBoolean
    
    for param in paramList:
        try:
            param.xpath( "vdef/value/text()")[0]
        except IndexError:
            paramName = param.xpath('name/text()')[0].data
            print >> sys.stdout , "the parameter named \"%s\" has no mandatory vdef"%paramName 
            _error = True
    
    #les parametres de type infile ne doivent pas avoir de vdef
    allParamsNode = doc.xpath( "//parameter")
    parser = Parser.ServiceParser()
    for paramNode in allParamsNode:
        param = parser.parseParameter( paramNode )
        vdef = param.getVdef()
        if vdef is not None:
            if param.isInfile():
                print >> sys.stdout , "the infile parameter named \"%s\" has a vdef" %param.getName()
            else:
                try:
                    param.reset( )
                except Exception ,err :
                    print >> sys.stdout , "the parameter named \"%s\" has an invalid vdef: %s" %( param.getName() , err )
            
if _error :
    sys.exit(1)
else:
    sys.exit(0)