#! /usr/bin/env python

import os, sys, getopt

# ====== config:

# append Mobyle Home to the search modules path
try:
    _MOBYLEHOME = os.environ[ 'MOBYLEHOME' ]
except KeyError:
    _MOBYLEHOME = '/pasteur/mobyle/Mobyle'
if _MOBYLEHOME not in sys.path:
    sys.path.append( _MOBYLEHOME )

# append Mobyle Src
if (os.path.join(_MOBYLEHOME,'Src')) not in sys.path:
    sys.path.append(os.path.join(_MOBYLEHOME,'Src'))

# ===== fin: end

import Cjobw


def usage():
    print """
    usage: jobw [options]
           jobw <special options> [options]

    Description:
        By default, display all informations of current Mobyle services.

        Informations are :
        - process number, batch system, queue, status, host name
        - job name, job id, user email, remote, date, session
        - command line

        Users can limit informations to display with <special options>.


     General options:
        -h               ... Print this message and exit.
        -E <email(s)>    ... Prints only jobs with the specified email(s).
                             <email(s)> is a list of email adresses separated with
                             coma
                             ex: toto@where.fr,titi@othercountry.uk
        -J <job name(s)> ... Prints only jobs with the specified job name(s).
                             <job name(s)> is a list of job name separated with coma
                             ex: blast2,toppred
        -K <job key(s)>  ... Prints only jobs with the specified job key(s).
                             <job key(s)> is a list of job key separated with coma
                             ex: A23345555,B3334445
        -Q <queue name>  ... Prints only jobs in the specified queue.
        -R <remote(s)>   ... Prints only jobs with the specified remote(s).
                             <remote(s)> is a list of ip adresse separated with coma
                             ex: 157.99.60.112,157.99.60.111
        -N <sessions(s)> ... Prints only jobs with the specified session(s)
                             <sessions(s)> is a list of session id separated with
                             coma
                             ex: 9dfb5ce6e1a24e2ff77c8eec8ab8cf4e
        -S <int|str>     ... Display Mobyle services sort by (date by default):
             1   date    ( date )
             2   email   ( user email )
             3   remote  ( remote )
             4   jobname ( job name )
             5   batch   ( batch )
             6   queue   ( queue )
             7   status  ( status )
             8   session ( session )

    Display options:

        Display only information associated with the following options, any
        combination is possible.:

        -n|number   ... Print process number
        -b|batch    ... Print batch system
        -q|queue    ... Print queue
        -s|status   ... Print status
        -i|Session  ... Print session

        -A|Admin    ... Print Admin option [bnqsS]

        -j|jobname  ... Print job name
        -k|jobkey   ... Print job key
        -e|email    ... Print user email
        -r|remote   ... Print remote
        -d|date     ... Print date

        -U|User     ... Print User option [deijr]

        -c|cmd      ... Print command line
    """


# ===== command line parser
try:
    opts, args = getopt.gnu_getopt( sys.argv[1:], "AbcdehijknqrsUE:J:K:N:Q:R:S:",
                                ["Admin","batch","cmd","date","email", "help",
                                 "session","jobname","jobkey","number",
                                 "queue","remote","status", "User",
                                 "emails=","jobN=", "jobK=",
                                 "sessions=", "queueN=", "remotes=", "sort="] )
    sp_opts = []
except getopt.GetoptError:
    usage()
    sys.exit( 0 )

# ===== options
jobNames, jobKeys, emails, remotes, sessions = [], [], [], [], []
queueKey, sortKey = None, None
if opts:
    while opts:
        o,v = opts[0]
        if o in ( "-S" , "--sort" ):
            if v in ('1','2','3','4','5','6','7','8', 'date','email','remote','jobname','batch','queue','status', 'session'):
                sortKey = v
                opts = opts[1:]
            else:
                usage()
                sys.exit( 0 )
        elif o in ("-E" , "--emails"):
            emails = v.split( ',')
            opts = opts[1:]
        elif o in ("-J" , "--jobN"):
            jobNames = v.split( ',')
            opts = opts[1:]
        elif o in ("-K" , "--jobK"):
            jobKeys = v.split( ',')
            opts = opts[1:]
        elif o in ("-N" , "--sessions"):
            sessions = v.split( ',')
            opts = opts[1:]
        elif o in ("-R" , "--remotes"):
            remotes = v.split( ',')
            opts = opts[1:]
        elif o in ("-Q" , "--queueN"):
            queueKey = v
            opts = opts[1:]
        else:
            sp_opts.append((o,v))
            opts = opts[1:]

# ===== basic jobw

jobs = Cjobw.JOBW( jobNames, jobKeys, emails, remotes, sessions )
if sortKey:
    jobs.setSortKey( sortKey )
if queueKey:
    jobs.setQueueKey( queueKey )

# ===== specials options
if sp_opts:
    jobs.turnOff_diplay()

for o, v in sp_opts:
    if o in ( "-h","--help" ):
        usage()
        sys.exit( 0 )
    if o in ( "-n", "--number" ):
        jobs.setDisplay( 'number', True )
    elif o in ( "-b", "--batch" ):
        jobs.setDisplay( 'batch', True )
    elif o in ( "-q" , "--queue"):
        jobs.setDisplay( 'queue', True )
    elif o in ( "-s" , "--status"):
        jobs.setDisplay( 'status', True )
    elif o in ( "-A" , "--Admin"):
        jobs.setDisplay( 'number', True )
        jobs.setDisplay( 'batch', True )
        jobs.setDisplay( 'queue', True )
        jobs.setDisplay( 'status', True )
    elif o in ( "-j" , "--jobname"):
        jobs.setDisplay( 'jobname', True )
    elif o in ( "-k" , "--jobkey"):
        jobs.setDisplay( 'jobkey', True )
    elif o in ( "-i" , "--session"):
        jobs.setDisplay( 'session', True )
    elif o in ( "-e" , "--email"):
        jobs.setDisplay( 'email', True )
    elif o in ( "-r" , "--remote"):
        jobs.setDisplay( 'remote', True )
    elif o in ( "-d" , "--date"):
        jobs.setDisplay( 'date', True )
    elif o in ( "-U" , "--User"):
        jobs.setDisplay( 'jobname', True )
        jobs.setDisplay( 'jobkey', True )
        jobs.setDisplay( 'session', True )
        jobs.setDisplay( 'email', True )
        jobs.setDisplay( 'remote', True )
        jobs.setDisplay( 'date', True )
    elif o in ( "-c" , "--command"):
        jobs.setDisplay( 'command', True )



# ==== basic display

jobs.display('str_bioweb')

