/**
 * Author: Herve Menager
 * Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.
 * Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.
 */

/**
 * @class MobyleRegistrationForm is a class that initializes AJAX behaviour for
 *        the registration form of the portal
 * 
 * @author Herve Menager
 * @organization Institut Pasteur
 * @contact mobyle@pasteur.fr
 */
MobyleRegistrationForm = Class.create();

MobyleRegistrationForm.prototype = {

    initialize: function() {
      
        this.rEmailEl = new MobyleInputField($('register_email'));
        this.rPasswEl = new MobyleInputField($('register_password'));
        this.rPasswCEl = new MobyleInputField($('register_password_check'));
        this.rEmailEl.el = this.rEmailEl.msgEl;
        this.rPasswEl.el = this.rPasswEl.msgEl;
        this.rPasswCEl.el = this.rPasswCEl.msgEl;
        $('register_submit').onclick = this.submitRegistrationRequest.bindAsEventListener(this);
      
    },
      
    submitRegistrationRequest: function() {
      
        if(this.rPasswEl.el.value!=this.rPasswCEl.el.value){
          this.rPasswEl.setInvalidFieldMessage("The password values you entered need to be identical");
        }else{
          var rf = this;
          this.p = new Object();
          this.p['email']=this.rEmailEl.el.value;
          this.p['password']=this.rPasswEl.el.value;
          new Ajax.Request('session_register.py',
          {
            method:'post',
            postBody: $H(this.p).toQueryString(),
            onSuccess: function(transport){
              // we get a json response, that is parsed to create the job's
				// menu entry
        	  portal.loadSessionInfoFromCookie();
              var answer = transport.responseText.evalJSON();
              if(answer.accountOk=="True"){
                portal.reload();
              }else{
                rf.rEmailEl.setInvalidFieldMessage(answer.msg);
              }
            }
          });
        }
      
    }
    
}


/**
 * @class MobyleSignInForm is a class that initializes AJAX behaviour for the
 *        sign-in form of the portal
 * 
 * @author Herve Menager
 * @organization Institut Pasteur
 * @contact mobyle@pasteur.fr
 */
MobyleSignInForm = Class.create();

MobyleSignInForm.prototype = {

    initialize: function() {
      
        this.sEmailEl = new MobyleInputField($('signin_email'));
        this.sPasswEl = new MobyleInputField($('signin_password'));
        this.sEmailEl.el = this.sEmailEl.msgEl;
        this.sPasswEl.el = this.sPasswEl.msgEl;
        $('signin_submit').onclick = this.submitSignInRequest.bindAsEventListener(this);
      
    },
  
    submitSignInRequest: function() {
      
        var sf = this;
        this.p = new Object();
        this.p['email']=this.sEmailEl.el.value;
        this.p['password']=this.sPasswEl.el.value;
        new Ajax.Request('session_signin.py',
        {
          method:'post',
          postBody: $H(this.p).toQueryString(),
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu
			// entry
        	portal.loadSessionInfoFromCookie();
            var answer = transport.responseText.evalJSON();
            if(answer.accountOk=="True"){
              portal.reload();
            }else{
              sf.sEmailEl.setInvalidFieldMessage(answer.msg);
            }
          }.bind(this)
        });
      
    }
    
}

/**
 * @class MobyleSignOffLink is a class that initializes AJAX behaviour for the
 *        sign-off link of the portal
 * 
 * @author Herve Menager
 * @organization Institut Pasteur
 * @contact mobyle@pasteur.fr
 */
MobyleSignOffLink = Class.create();

MobyleSignOffLink.prototype = {

    initialize: function() {
      
        $('signoff_submit').onclick = this.submitSignOffRequest.bindAsEventListener(this);
      
    },
    
    submitSignOffRequest: function() {
      
        var sl = this;
        new Ajax.Request('session_signoff.py',
        {
          method:'post',
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu
			// entry
        	portal.loadSessionInfoFromCookie();
            var answer = transport.responseText.evalJSON();
            if(answer.accountOk=="True"){
              portal.reload();
            }else{
              sf.sEmailEl.setInvalidFieldMessage(answer.msg);
            }
          }
        });
      
    }
    
}

/**
 * @class MobyleSignInForm is a class that initializes AJAX behaviour for the
 *        sign-in form of the portal
 * 
 * @author Herve Menager
 * @organization Institut Pasteur
 * @contact mobyle@pasteur.fr
 */
MobyleActKeyForm = Class.create();

MobyleActKeyForm.prototype = {

    initialize: function() {
        this.sEmailEl = new MobyleInputField($('actkey_email'));
        this.sPasswEl = new MobyleInputField($('actkey_password'));
        this.sKeywEl = new MobyleInputField($('actkey_key'));
        this.sEmailEl.el = this.sEmailEl.msgEl;
        this.sPasswEl.el = this.sPasswEl.msgEl;
        this.sKeywEl.el = this.sKeywEl.msgEl;
        this.sEmailEl.el.value = portal.email;
        this.sPasswEl.el.value = portal.password;
        $('actkey_submit').onclick = this.submitActKeyRequest.bindAsEventListener(this);
    },
      
    submitActKeyRequest: function() {
        var sf = this;
        this.p = new Object();
        this.p['email']=this.sEmailEl.el.value;
        this.p['password']=this.sPasswEl.el.value;
        this.p['actkey']=this.sKeywEl.el.value;
        new Ajax.Request('session_activate.py',
        {
          method:'post',
          postBody: $H(this.p).toQueryString(),
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu
			// entry
				portal.loadSessionInfoFromCookie();
                var answer = transport.responseText.evalJSON();
                if(answer.accountOk=="True"){
                  portal.reload();
                }else{
                  sf.sEmailEl.setInvalidFieldMessage(answer.msg);
                }
            }
        });
    }
}
