/**
 * Author: Herve Menager
 * Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.
 * Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.
 */

/**
 * @class MobylePortal is a class that initializes AJAX behaviour in the portal
 *        and gives a context to access all usefull objects globally.
 * 
 * It includes:
 * <ul>
 * <li>files list initialization</li>
 * <li>programs list initialization</li>
 * <li>tutorials initialization</li>
 * <li>tabs initialization</li>
 * </ul>
 * 
 * @extends MobyleWidget
 */
MobylePortal = Class.create();

MobylePortal.prototype = {

	initialize : function(el) {

		portal = this; // we declare the object to be able to refer to it even
						// during initialization (hack...)
	this.el = el;
	
	this.loadSessionInfoFromCookie();

	if(!this.sessionKey){
    	this.reload();
    	return;
    }
	
	this.drawer = new MobyleDrawer($("drawer"));
	new MobyleProgramsList();

	this.anonymousSession = $F('anonymousSession') == "True";
	this.authenticatedSession = $F('authenticatedSession') == "True";


	if ($('email_tabPanel'))
		$('sessionInfodd').insertTab('email');
	if ($('signin_submit')) {
		$('sessionInfodd').insertTab('signin');
		new MobyleSignInForm();
		if (!$('email_tabPanel'))
			$('signin').showTab();
	}
	if ($('register_submit')) {
		$('sessionInfodd').insertTab('register');
		new MobyleRegistrationForm();
	}
	if ($('signoff_submit'))
		new MobyleSignOffLink();
	if ($('actkey_submit')) {
		this.actkeyForm = new MobyleActKeyForm();
		$('sessionInfodd').insertTab('activate');
	}
	if ($('email_tabHandle'))
		$('email_tabHandle').showTab();

	$('portalMain').insertTab('welcome', 'Welcome');
	$('portalMain').insertTab('services', 'Programs');
	$('services_tabPanel').insertTabsContainer();
	$('portalMain').insertTab('data', 'Data Bookmarks');
	$('portalMain').insertTab('jobs', 'Jobs');
	$('jobs_tabPanel').insertTabsContainer();
	$('portalMain').insertTab('tutorials', 'Tutorials');
	$('tutorials_tabPanel').insertTabsContainer();
	$('welcome_tabHandle').showTab();

	// link from data bookmarks menu
	Event.observe("filesListUl", 'click', function(e) {
		$('data_tabHandle').showTab();
		Event.stop(e);
	}.bindAsEventListener(this));

	// tutorial links mechanism initialization
	$("tutorialsdd").down().descendants().each( function(el) {
		if (el.href) {
			Event.observe(el, 'click', function(e) {
				$('tutorials_tabPanel').getTutorialTab(el.href, el.title);
				Event.stop(e);
			}.bindAsEventListener(this));
		}
	}.bind(this));

	this.banks = new MobyleJSONList('banks_list.py');

	this.inputs = new MobyleJSONList('inputs_list.py');

	new Ajax.Request('datatypes_list.py', {
		method :'get',
		onSuccess : function(transport) {
			this.datatypes = $H(transport.responseText.evalJSON());
		}.bind(this)
	});

	this.data = new MobyleJSONList('data_list.py');
	this.filesList = new MobyleFilesUl();
	this.filesListRB = new MobyleJSONRefresh($('filesListRefreshButton'),
			portal.data);

	this.forms = $H();

	// setting up the data management page
	this.dataManagement = new MobyleDataManagement();
	this.dataGauge = new MobyleSessionGauge(portal.data);

	this.jobs = new MobyleJSONList('session_jobs_list.py');
	this.jobsList = new MobyleJobsUl();
	this.jobsListRB = new MobyleJSONRefresh($('jobsListRefreshButton'),
			portal.jobs);

	if ($('openedForms')) {
		$('openedForms').value.split(',').each( function(form) {
			$('services_tabPanel').getFormTab(form);
		});
	}

	if ($('openedJobs')) {
		$('openedJobs').value.split(',').each( function(job) {
			$('jobs_tabPanel').getJobTab(job);
		});
	}

	new MobyleToolTipManager();

},

reload : function() {

	window.location.reload();

},

loadSessionInfoFromCookie : function() {

	this.email = this.loadValueFromCookie("email");
	this.sessionKey = this.loadValueFromCookie("sessionKey");
	this.password = this.loadValueFromCookie("password");
	this.activated = (this.loadValueFromCookie("activated") == "True");
	this.authenticated = (this.loadValueFromCookie("authenticated") == "True");
	this.resetPortal = (this.loadValueFromCookie("resetPortal") == "True");
	if ($("account_email_menu")) {
		$("account_email_menu").value = this.email;
	}
	if (this.resetPortal) {
		portal.reload();
	}

},

loadValueFromCookie : function(key) {

	var regex = new RegExp(key + '\s*="?(.*?)"?(;|$)');
	var cookies = document.cookie.toString();
	var match = cookies.match(regex);
	if (match) {
		return unescape(match[1]);
	} else {
		return '';
	}

},

reload : function() {
	window.location.reload();
}

}