/**
 * Author: Herve Menager Organization:'Biological Software and Databases' Group,
 * Institut Pasteur, Paris. Distributed under GPLv2 Licence. Please refer to the
 * COPYING.LIB document.
 */

// firebug logging
function reportMobyleError(err) {
	console.group("Mobyle error");
	console.dir(err);
	console.trace();
	console.groupEnd();
}

Ajax.Responders
		.register( {
			// this hack forces to avoid caching throughout every ajax request,
			// because IE tends to force cache when using GET requests.
			onCreate : function(o) {
				o.options.requestHeaders = $H( {
					"Cache-Control" :"post-check=1,pre-check=2,no-cache,must-revalidate",
					"If-Modified-Since" :"Sat, 1 Jan 2000 00:00:00 GMT"
				});
			},
			// this traces any ajax exception that might be raised
			onException : function(err) {
				reportMobyleError(err);
			}
		});

// this wraps any event handling function to catch raised exceptions
Event.observe = Event.observe.wrap( function(proceed, element, eventName,
		handler) {
	handler = handler.wrap( function(proceed, e) {
		try {
			return proceed(e);
		} catch (err) {
			reportMobyleError(err);
		}
	});
	return proceed(element, eventName, handler);
});

Event.observe(window, 'load', function() {
	portal = new MobylePortal("mainContainer");
});