/**
 * Author: Herve Menager
 * Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.
 * Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.
 */

/**
 * @class MobyleForm is a MobyleWidget class that represents a form in the
 *        portal page It includes:
 *        <ul>
 *        <li>cgi call to get the html form from the server</li>
 *        <li>databoxes creation</li>
 *        <li>form verification</li>
 *        <li>form submission</li>
 *        </ul>
 * 
 * @extends MobyleWidget
 */

MobyleForm = Class.create();
MobyleForm.prototype = Object.extend({

  cgiurl:'form.py',

  initAjaxParams: function() {
    this.el=$(this.otherparams.get('el'));
  },
  
  remove: function(){
    this.databoxes.values().each(
      function(databox){
        databox.remove();
      }
    );
  },

  onCompleteFunction: function() {
      // show e-mail input field on the left if not specified previously (i.e.
		// and no registered session as well)
      if(!(portal.email && portal.email!='') && $('email_tabHandle')){
        $('email_tabHandle').showTab();
      }
      this.programName=this.cgiparams.get('programUrl');
      this.formEl=$(this.programName+"Form");
      if(this.formEl){
        // general error messages field
        this.inputField = new MobyleInputField(this.formEl);
        // creating the databoxes for the corresponding form
        this.databoxes=$H();
        this.el.select(".databox").each(function(node) {
          var isDataInput = node.getAttribute('isDataInput');
          var el = node;
          var form = this;
          var programName = this.programName;
          var parameterName = el.select('.parameterName')[0].value;
          var parameterDataType = el.select('.parameterDataType')[0].value;
          var parameterBioType = el.select('.parameterBioType')[0].value;
          var parameterCard = el.select('.parameterCard')[0].value;
          this.databoxes.set(parameterName, new MobyleDatabox(el, form, programName, parameterName, parameterDataType, parameterBioType, parameterCard));
          if(this.otherparams.get('paramName')==parameterName){
            this.databoxes.get(parameterName).setDataBoxValueTo(this.otherparams.get('fileName'));
          }
        }.bind(this));
  
        // creating the e-mail input field
        if($('account_email_menu')){
          this.emailInputField = new MobyleEmail($('account_email_menu'),this.formEl.select('.parameters')[0]);
        }else{
          this.inputField.setInvalidFieldMessage("This server requires that you register/sign-in before to run a program");          
        }
        // overriding e-mail field mandatory property.
        if($F('email_mandatory_'+ this.programName)=='true' && this.emailInputField){
          this.emailInputField.mandatory = true;
        }
        
        // creating the additional parameters
        this.parameters = $H();
        this.formParEls = this.el.select('.form_parameter');
  
        var inputNames = this.formParEls.collect(function(el){return el.getAttribute('name');}).uniq();
        
        inputNames.each(function(inputName) {
          parName = inputName.sub(this.programName+'_', '');
          if(!this.parameters.get(parName)){
          	var paramEls = this.formParEls.findAll(function(s) {
                return s.name==inputName;
            })
            if(paramEls.size()>0){
                this.parameters.set(parName,new MobyleFormParameter(this.formParEls.findAll(function(s) {
                    return s.name==inputName;
                  })));
            }
          }
        }.bind(this));
  
        // setting submit button behaviour
        this.submitButton = $("submit_" + this.programName);
        this.submitButton.onclick = this.requestSubmit.bindAsEventListener(this);
        // setting reset button behaviour
        this.resetButton = $("reset_" + this.programName);
        this.resetButton.onclick = this.reset.bindAsEventListener(this);
        
        Object.extend(this, new MobyleHelpPopUps(this.programName));

        this.el.select(".commentToggle").each(function(node) {
          new MobyleCommentLink(node);
        });
        
        // behaviour for help pages button that scrolls to the help links
        if($("help_pages_btn_" + this.programName)){
          if($("help_pages_list_" + this.programName).select('a').size()==1){
          	$("help_pages_btn_" + this.programName).onclick = function(){window.open($("help_pages_list_" + this.programName).down('a').href)}.bindAsEventListener(this);        	  
          }else{
        	$("help_pages_btn_" + this.programName).onclick = function(){$("help_pages_list_" + this.programName).scrollTo()}.bindAsEventListener(this);
          }
        }

        // setting the behaviour for the captcha problem form
        // show captcha pop-up when image loaded
        Event.observe(this.programName + "CaptchaImage", 'load', 
          function(e){
            Element.show($(this.programName + "CaptchaPopup"));
            $(this.programName + "CaptchaSolution").focus();
        }.bindAsEventListener(this));
        // form submission
        Event.observe(this.programName + "CaptchaPopupForm", 'submit', 
          function(e){
            this.checkCaptcha();
            Event.stop(e);
        }.bindAsEventListener(this));
		// update tab handle label
		if($(this.programName+'_tabHandle')){
		  $(this.programName+'_tabHandle').innerHTML = this.el.select('.formTitle h1')[0].innerHTML;
		}
      }else{
		// update tab handle label
		if($(this.programName+'_tabHandle')){
		  $(this.programName+'_tabHandle').innerHTML = this.el.select('.error_title')[0].innerHTML;
		}	  	
	  }
  },

  reset: function(){
    Element.show(this.popUpName + "PopupOverlay");
    Element.show(this.popUpName + "ResetPopup");
    this.build();
  },
  
  check: function(){
	  this.inputField.removeInvalidFieldMessage();
      var validatedFieldsResults = $H();
      if(this.emailInputField){
        validatedFieldsResults.set('email', this.emailInputField.check());
      }
      this.databoxes.values().each(function(param){
    	  if(param.valueInputField){
    		  param.valueInputField.removeInvalidFieldMessage();
    	  }
        });
      this.parameters.values().each(function(param){
        param.removeInvalidFieldMessage();
      });
      var firstFalseFound = validatedFieldsResults.values().find(function(value){
          return (value==false);
        });
      return (firstFalseFound==undefined);
  },
  
  requestSubmit: function() {
      if(this.check()){
        if(portal.sessionKey){
          if(portal.activated==true){
            // submit right away
            this.submit();
          }else if (portal.authenticated==true){
            this.inputField.setInvalidFieldMessage("To be allowed to submit a job you need to confirm your e-mail adress. You can do so by clicking on the link we sent you.");
          }else{
            // here ask the user to solve the captcha problem then eventually
			// proceed with submission
            this.getNewCaptchaProblem();
          }
        }else{
          this.inputField.setInvalidFieldMessage("You need to open a session on the system before to be able to submit a job.");
        }
      }
  },
  
  checkCaptcha: function() {
      var cr = $F(this.programName + "CaptchaSolution");
      this.p = new Object();
      this.p['solution']=cr;
      new Ajax.Request('captcha_check.py',
      {
        method:'post',
        postBody: $H(this.p).toQueryString(),
        onSuccess: function(transport){
          // we get a json response, that is parsed to create the job's menu
			// entry
            
              var answer = transport.responseText.evalJSON();
              if(answer.captchaOk=="True"){
                portal.activated=true;
                Element.hide($(this.programName + "PopupOverlay"));
                Element.hide($(this.programName + "CaptchaPopup"));
                this.submit();
              }else{
                this.getNewCaptchaProblem();
              }
          }.bind(this)
      });
  },
  
  getNewCaptchaProblem: function(){
	  $(this.programName + "CaptchaSolution").clear();
      Element.show($(this.programName + "PopupOverlay"));
      $(this.programName + "CaptchaImage").src = "";
      $(this.programName + "CaptchaImage").src = "captcha_get.py?" + new Date();
  },
  
  submit: function() {
      if(this.check()){
        // launching the job...
        this.p = new Object();
        if(portal.email){
          this.p['email']=portal.email;
        }
        if(this.emailInputField){
          this.p['email']=$F(this.emailInputField.el);
        }
        this.setCgiPars();
        // disabling the form and showing wait screen
        this.submitButton.disable();
        Element.show($(this.programName + "PopupOverlay"));
        Element.show($(this.programName + "JobPopup"));
        // continue launching...
        this.p._action = 'getJSON';
        new Ajax.Request('session_job_submit.py',
        {
        method:'post',
        postBody: $H(this.p).toQueryString(),
        onSuccess: function(transport){
          // we get a json response, that is parsed to create the job's menu
			// entry
              portal.loadSessionInfoFromCookie();
              job = transport.responseText.evalJSON();
              this.lastLaunchedJobInfo = job; // we save this info in case the
												// "get help" option is used.
              if(job.id && !job.errormsg){ 
                job.program = this.programName;
				// the two following lines are here for ie-compatibility
				// purposes:
				// the hiding cannot be done in ie if the popups are in an
				// already hidden element
	            $(this.programName + "PopupOverlay").hide();
	            $(this.programName + "JobPopup").hide();
				$('jobs_tabPanel').getJobTab(job.id);
              }else{
                this.showAskHelpButton();
                if(job.errorparam){
                  if (this.databoxes.get(job.errorparam)){
                    this.databoxes.get(job.errorparam).valueInputField.setInvalidFieldMessage(job.errormsg);
                  }
                  if (this.parameters.get(job.errorparam)){
                    this.parameters.get(job.errorparam).setInvalidFieldMessage(job.errormsg);
                  }
                 job.errormsg = job.errorparam + ': ' + job.errormsg;
                }else{
                  this.inputField.setInvalidFieldMessage(job.errormsg);
                }
              }
          }.bind(this),
        onComplete: function(){
          // hiding wait screen and enabling back the form...
          this.submitButton.enable();
          $(this.programName + "PopupOverlay").hide();
          $(this.programName + "JobPopup").hide();
          // update data and jobs lists
          portal.data.build();
          portal.jobs.build();
		  portal.loadSessionInfoFromCookie();
        }.bind(this)
        });
      }
  },
  

  setCgiPars: function() {
      var elements = Form.getElements(this.el);
      var f =this;
      elements.each(
      function(fe){
        if($F(fe)!=null){
          // Warning no parameter value should be stripped here, since some
			// data formats include white spaces and/or carriage returns (e.g.,
			// swissprot)
          f.p[fe.name] = $F(fe).toArray().join('');
        }
      }
      );
  }
  
},MobyleWidget.prototype);

MobyleInputField = Class.create();

MobyleInputField.prototype = {

  initialize: function(msgEl,summaryMsgEl,msgPrompt) {
    
      this.msgEl = $(msgEl);
      if(summaryMsgEl!=undefined){
        this.summaryMsgEl = $(summaryMsgEl);
      }
      if(msgPrompt!=undefined){
        this.msgPrompt=msgPrompt + ": ";
      }else{
        this.msgPrompt='';
      }
      Event.observe(this.msgEl, 'focus', 
        function(e){
    	  this.removeInvalidFieldMessage();
      	}.bindAsEventListener(this));
    
  },
  
  setInvalidFieldMessage: function(message){
    
      this.message = message;
      // remove previous messages about the field
      this.removeInvalidFieldMessage();
      // create field message
      var m = document.createElement("div");
	  Element.extend(m);
	  m.addClassName("error");
      m.appendChild(document.createTextNode(message));
      this.msgEl.parentNode.insertBefore(m,this.msgEl);
      // create summary message
      if(this.summaryMsgEl!=undefined){
        var p = document.createElement('span');
        p.appendChild(document.createTextNode(this.msgPrompt));
        var m = document.createElement("div");
  	    Element.extend(m);
	    m.addClassName("error");
        m.appendChild(p);
        m.appendChild(document.createTextNode(message));
        this.summaryMsgEl.parentNode.insertBefore(m,this.summaryMsgEl);
      }
    
  },
    
  removeInvalidFieldMessage: function(){
    
      // remove field message
      if(this.msgEl.previousSiblings()!=undefined){
        this.msgEl.previousSiblings().each(
          function(el){
            if(el.hasClassName("error")){
              el.remove();
            }
          }.bind(this)
        );      
      }
      // remove summary message
      if(this.summaryMsgEl!=undefined && this.summaryMsgEl.previousSiblings()!=undefined){
        this.summaryMsgEl.previousSiblings().each(
          function(el){
            if(el.hasClassName("error") && el.down('span').innerHTML.unescapeHTML()==this.msgPrompt){
              el.remove();
            }
          }.bind(this)
        );
      }
    
  }
};

MobyleFormParameter = Class.create();

MobyleFormParameter.prototype = {

  initialize: function(el) {
    
      this.el = el;
      this.name = this.el.first().name;
      try{
        this.prompt = $('for_'+this.el.first().id).innerHTML.unescapeHTML(); // getting
																				// the
																				// parameter
																				// prompt
																				// using
																				// the
																				// DOM
      }catch(e){
        this.prompt = this.name;
      }
      Object.extend(this, new MobyleInputField(el.first(),el.first().up('.parameters'),this.prompt));
      this.mandatory = this.el.first().hasClassName('mandatory');	
      this.type = this.el.first().type;
      this.el.each(function(element){
        element.onchange = this.removeInvalidFieldMessage.bindAsEventListener(this);
	  }.bind(this));
    
  },
 
  getValue: function(){
    
      if(this.type=='radio'){
        var valueEl = this.el.find(function(element){
          return element.checked;
        });
        if(valueEl){
          return valueEl.value;
        }else{
          return null;
        }
      }else{
        return this.el.first().value;
      }
    
  }  
  
};

MobyleEmail = Class.create();

MobyleEmail.prototype = {

  initialize: function(el, formEl) {
      this.el = el;
      Object.extend(this, new MobyleInputField(el,formEl,"e-mail"));
            this.mandatory = this.el.hasClassName('mandatory');
      this.el.onchange = this.check.bindAsEventListener(this);
      if(portal.email){
        // e-mail value must be preset and readonly if it has been previously
		// set in the session
        this.el.value=portal.email;
      }
  },

  check: function(){
        re = /^.+@.+\..{2,3}$/;
        if(this.mandatory && this.el.value==''){
          this.setInvalidFieldMessage("mandatory to run this program");
          $('email_tabHandle').showTab();
          return false;
        }
        if(this.el.value!='' && !re.test(this.el.value)){
          // Element.addClassName(this.el,'invalid_form_field');
          this.setInvalidFieldMessage("Invalid e-mail value: "+this.el.value);
          $('email_tabHandle').showTab();
          return false;
        }else{
          // Element.removeClassName('invalid_form_field');
          this.removeInvalidFieldMessage();
          return true;
        }
  }
  
};

MobyleCommentLink = Class.create();
MobyleCommentLink.prototype = {
  initialize: function(el) {
      this.el = el;
      this.el.onclick = this.toggleComment.bind(this);
  },
  
  toggleComment: function(el) {
      Element.toggle($($(this.el).readAttribute('for')));
  }
  
};

MobyleHelpPopUps = Class.create();
MobyleHelpPopUps.prototype = {

  initialize: function(popUpName) {
      this.popUpName = popUpName;
	  this.helpInputField = new MobyleInputField($(this.popUpName + "HelpMessage"));
  },

  showAskHelpButton: function(){
      Element.show('helpdisplay_'+this.popUpName);
      $('helpdisplay_'+this.popUpName).onclick = this.displayHelpForm.bindAsEventListener(this);    
  },
  
  hideAskHelpButton: function(){
      Element.hide('helpdisplay_'+this.popUpName);
  },
  
  displayHelpForm: function() {
	  $(this.popUpName + "HelpEmail").value = portal.email;
      this.showHelpForm();
      $(this.popUpName + "HelpSubmit").onclick = function(){
		// it is mandatory to write a message
	  	if ($(this.popUpName + "HelpMessage").value.strip() == '') {
			this.helpInputField.setInvalidFieldMessage("please enter a message");
			return;
		}
	  	if ($(this.popUpName + "HelpEmail").value.strip() == '') {
			this.helpInputField.setInvalidFieldMessage("please provide an email so that we can contact you");
			return;
		}
		if (this.lastLaunchedJobInfo != null) {
			this.p = this.lastLaunchedJobInfo;
		}
		else {
			this.p = this.jobInfo;
		}
		this.p['message'] = $(this.popUpName + "HelpMessage").value;
		this.p['helpResponseEmail'] = $(this.popUpName + "HelpEmail").value;
		new Ajax.Request('help_request.py', {
			method: 'post',
			postBody: $H(this.p).toQueryString(),
			onCreate: function(){
				$(this.popUpName + "HelpSubmit").disable();				
			}.bind(this),
			onSuccess: function(transport){
				// we get a json response, that is parsed to create the job's
				// menu entry
					answer = transport.responseText.evalJSON();
					$(this.popUpName + "HelpConfirmationMessage").value = answer['msg_body'];
					// this.hideAskHelpButton(); this button is not hidden
					// anymore, because
					// the protection could be easily overriden and the overall
					// behaviour just seemed puzzling
					if(answer['errormsg'] && answer['errormsg']!=''){
						this.helpInputField.setInvalidFieldMessage(answer['errormsg']);
						return;
					}
					// hiding wait screen showing confirmation...
					this.hideHelpForm();
					this.showHelpConfirmation();
					// going back to the form...
					$(this.popUpName + "HelpConfirmationOk").onclick = this.hideHelpConfirmation.bindAsEventListener(this);
			}
.bind(this)						,
			onComplete: function(){
				$(this.popUpName + "HelpSubmit").enable();
			}
.bind(this)
		});
      }.bindAsEventListener(this);
      $(this.popUpName + "HelpCancel").onclick = this.hideHelpForm.bindAsEventListener(this);
    
  },
  
  showHelpForm: function(){
      Element.show(this.popUpName + "PopupOverlay");
      Element.show(this.popUpName + "HelpPopup");
  },
  
  hideHelpForm: function(){
      Element.hide(this.popUpName + "PopupOverlay");
      Element.hide(this.popUpName + "HelpPopup");
      $(this.popUpName + "HelpMessage").value = '';
  },

  showHelpConfirmation: function(){
      Element.show(this.popUpName + "PopupOverlay");
      Element.show(this.popUpName + "HelpConfirmation");
  },

  hideHelpConfirmation: function(){
      Element.hide(this.popUpName + "PopupOverlay");
      Element.hide(this.popUpName + "HelpConfirmation");
  }

}