/**
 * Author: Herve Menager Organization:'Biological Software and Databases' Group,
 * Institut Pasteur, Paris. Distributed under GPLv2 Licence. Please refer to the
 * COPYING.LIB document.
 */

MobyleDrawer = Class.create();

MobyleDrawer.prototype = {

	initialize : function(el) {
		this.el = el;
		this.titleEls = this.el.select("dt");
		$A(this.titleEls).each( function(dtEl) {
			Event.observe(dtEl, 'click', function(event) {
				Event.element(event).toggleDrawerItem();
				Event.stop(event);
			});
		});
	}

};

drawerMethods = {

	showDrawerItem : function(element) {
		drawerMethods.invokeDrawerItem(element, 'show');
	},

	hideDrawerItem : function(element) {
		drawerMethods.invokeDrawerItem(element, 'hide');
	},

	toggleDrawerItem : function(element) {
		drawerMethods.invokeDrawerItem(element, 'toggle');
	},

	invokeDrawerItem : function(element, action) {
		if ($(element).match('dt') && $(element).next('dd')) {
			Element.Methods[action]($(element).next('dd'));
		}
	}

}

Element.addMethods(drawerMethods);