/**
 * Author: Herve Menager
 * Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.
 * Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.
 */
/**
 * @class MobyleDatabox is a class that represents a databox in the portal page
 *        It includes:
 *        <ul>
 *        <li>cgi call to get the html form from the server</li>
 *        <li>fields creation</li>
 *        <li>data verification</li>
 *        </ul>
 * 
 */
MobyleDatabox = Class.create();
MobyleDatabox.prototype = Object
		.extend( {

			initialize : function(el, form, programName, parameterName,
					parameterDataType, parameterBioType, parameterCard) {
				this.el = el;
				this.form = form;
				this.programName = programName;
				this.parameterName = parameterName;
				this.parameterDataType = parameterDataType;
				this.parameterBioType = parameterBioType;
				this.parameterCard = $A(parameterCard.split(','));
				this.minCard = this.parameterCard.first();
				this.lastCard = this.parameterCard.last();
				if (this.minCard == '') {
					this.minCard = '0';
				}
				if (this.maxCard == '') {
					this.maxCard = 'n';
				}
				this.databoxId = this.programName + '_' + this.parameterName;
				try {
					this.prompt = $('for_' + this.databoxId).innerHTML; // getting
																		// the
																		// parameter
																		// prompt
																		// using
																		// the
																		// DOM
				} catch (e) {
					this.prompt = this.parameterName;
				}
				// data value
				if ($(this.databoxId + '_data')) {
					this.valueEl = $(this.databoxId + '_data');
				}
				// data name in session
				if ($(this.databoxId + '_sname')) {
					this.sNameEl = $(this.databoxId + '_sname');
				}
				// data user name)
				if ($(this.databoxId + '_uname')) {
					this.uNameEl = $(this.databoxId + '_uname');
				}
				this.databoxFields = $H();
				this.historyFields = $H();
				if ($('data_input_paste_' + this.databoxId)) {
					this.databoxFields.set('paste', new MobylePasteDataField(
							$('data_input_paste_' + this.databoxId),
							$('dataInputType_' + this.databoxId + '_paste'),
							this));
					this.historyFields.set('paste',
							new MobyleHistoryDataField(
									$('history_paste_' + this.databoxId),
									'paste', this));
				}
				if ($('data_input_db_' + this.databoxId)) {
					this.databoxFields
							.set(
									'db',
									new MobyleDBDataField(
											$('data_input_db_' + this.databoxId),
											$('data_input_db_db_' + this.databoxId),
											$('data_input_db_id_' + this.databoxId),
											$('data_input_db_submit_' + this.databoxId),
											$('dataInputType_' + this.databoxId + '_db'),
											this));
					this.historyFields.set('db', new MobyleHistoryDataField(
							$('history_db_' + this.databoxId), 'db', this));
				}
				if ($('data_input_upload_' + this.databoxId)) {
					this.databoxFields.set('upload', new MobyleFileDataField(
							$('data_input_upload_' + this.databoxId),
							$('dataInputType_' + this.databoxId + '_upload'),
							this));
					this.historyFields.set('upload',
							new MobyleHistoryDataField(
									$('history_upload_' + this.databoxId),
									'upload', this));
				}
				if ($('data_input_result_' + this.databoxId)) {
					this.databoxFields.set('result', new MobyleResultDataField(
							$('data_input_result_' + this.databoxId),
							$('dataInputType_' + this.databoxId + '_result'),
							this));
					var db = this;
					var onBuiltFunction = function() {
						// do not display result option if no result data
						// bookmark available...
						if (this.data.size() == 0) {
							$('dataInputType_' + db.databoxId + '_result')
									.disable();
							$('dataInputType_' + db.databoxId + '_result').up()
									.hide();
							if ($('dataInputType_' + db.databoxId + '_result').checked) {
								// switch to another input mode if result is the
								// current selected input mode
								db.setInputField(db.databoxFields.get('paste'));
							}
						} else {
							$('dataInputType_' + db.databoxId + '_result')
									.enable();
							$('dataInputType_' + db.databoxId + '_result').up()
									.show();
						}
					};
					this.historyFields.set('result',
							new MobyleHistoryDataField(
									$('history_result_' + this.databoxId),
									'result', this, onBuiltFunction));
				}
				if (this.valueEl != null) {
					this.valueInputField = new MobyleInputField(this.valueEl,
							this.valueEl.up('.parameters'), this.prompt);
					this.editBtn = $('data_input_edit_' + this.databoxId);
					this.clearBtn = $('data_input_reset_' + this.databoxId);
					this.forbidEditMsg = $('data_input_editforbid_' + this.databoxId);
					this.forbidEditMsg.hide();

					this.clearBtn.onclick = this.clear
							.bindAsEventListener(this);
					this.editBtn.onclick = this.switchToEdit
							.bindAsEventListener(this);
				}
				if (this.databoxFields.get('paste')) {
					this.setInputField(this.databoxFields.get('paste'));
				} else {
					this.setInputField(this.databoxFields.get('upload'));
				}
			},

			switchToEdit : function() {
				this.setInputField(this.databoxFields.get('paste'), true);
				this.sNameEl.clear();
			},

			remove : function() {
				this.historyFields.values().each( function(hdf) {
					hdf.dataSelectData.remove();
				});
			},

			setDataBoxValueTo : function(fileName) {
				this.setInputField(this.databoxFields.get('result'));
				this.historyFields.get('result').dataSelectData
						.selectEntry(fileName);
			},

			setInputField : function(selectedField, doNotClear) {
				if (this.valueInputField) {
					this.valueInputField.removeInvalidFieldMessage();
					this.setEditable(selectedField.el.id == this.databoxFields
							.get('paste').el.id);
				}
				if (!doNotClear) {
					this.clear();
				}
				this.databoxFields.each( function(hash) {
					databoxField = hash.value;
					databoxField.removeInvalidFieldMessage();
					if (databoxField.el.id == selectedField.el.id) {
						databoxField.display();
						databoxField.radioEl.checked = true;
					} else {
						databoxField.hide();
						databoxField.radioEl.checked = false;
					}
				});
			},

			setEditable : function(editable) {
				if (editable) {
					this.valueEl.enable();
					this.valueEl.setStyle( {
						overflow :'auto'
					});
					this.editBtn.disable();
					this.editBtn.hide();
				} else {
					this.valueEl.disable();
					this.valueEl.setStyle( {
						overflow :'hidden'
					});
					this.editBtn.enable();
					this.editBtn.show();
				}
			},

			onGetData : function(responseText) {
				response = responseText.strip().evalJSON();
				if(response.content!=null){
					if (this.valueEl != null) {
						this.valueEl.value = response.content;
						this.setEditable(!response.headFlag == "HEAD");
					}
					if (this.sNameEl != null) {
						this.sNameEl.value = response.safeName;
					}
					if (this.uNameEl != null) {
						this.uNameEl.value = response.userName;
					}
					if (this.valueEl != null && response.headFlag != "HEAD") {
						this.editBtn.enable();
						if (this.forbidEditMsg)
							this.forbidEditMsg.hide();
					} else {
						if (this.editBtn)
							this.editBtn.disable();
						if (this.forbidEditMsg)
							this.forbidEditMsg.show();
						if (this.valueEl)
							this.valueEl.value += "...";
					}
				}
				if (response.errormsg) {
					this.valueInputField
							.setInvalidFieldMessage(response.errormsg);
				}
			},

			clear : function() {
				if (this.sNameEl != null) {
					this.sNameEl.value = '';
				}
				if (this.uNameEl != null) {
					this.uNameEl.value = '';
				}
				if (this.valueEl != null) {
					this.valueEl.value = '';
				}
				if (this.forbidEditMsg)
					this.forbidEditMsg.hide();
			},

			callCheckCGI : function(callbackFct) {
				if (!this.valueEl.value.blank()) {
					$(this.databoxId + "_fmt_count").innerHTML = '';
					$(this.databoxId + "_fmt_name").innerHTML = '';
					$(this.databoxId + "_fmt_errormsg").innerHTML = '';
					var cgipars = new Object();
					cgipars.datatype = this.parameterDataType;
					cgipars.data = this.valueEl.value;
					this.valueInputField.removeInvalidFieldMessage();
					new Ajax.Request(
							'data_check.py',
							{
								method :'post',
								postBody :$H(cgipars).toQueryString(),
								onLoading : function() {
									this.valueEl.readonly = true;
								}.bind(this),
								onSuccess : function(transport) {
									this.valueEl.readonly = false;
									var response = transport.responseText
											.evalJSON();
									// if there is an error message, it is a
									// server problem, hence we do not block
									// submission
									if (response.errormsg) {
										$(this.databoxId + "_fmt_errormsg").innerHTML = response.errormsg;
									}
									if (response.format != null) {
										$(this.databoxId + "_fmt_name").innerHTML = response.format;
									} else {
										$(this.databoxId + "_fmt_name").innerHTML = '';
									}
									if (response.format != null) {
										$(this.databoxId + "_fmt_count").innerHTML = response.count;
									} else {
										$(this.databoxId + "_fmt_count").innerHTML = '';
									}
								}.bind(this),
								onComplete : function() {
									this.check();
								}.bind(this)
							});
				}
			}

		});

MobyleDataboxField = Class.create();

MobyleDataboxField.prototype = {

	initialize : function(el, radioEl, databox) {
		this.el = el;
		Object.extend(this, new MobyleInputField(this.el, this.el
				.up('.parameters'), databox.prompt));
		this.databox = databox;
		this.radioEl = radioEl;
		this.radioEl.onclick = this.onSelectRadio.bindAsEventListener(this);
	},

	onSelectRadio : function() {
		this.databox.setInputField(this);
	},

	display : function() {
		Element.show(this.el);
		this.radioEl.setAttribute("checked", "checked");
	},

	hide : function() {
		Element.hide(this.el);
		this.radioEl.removeAttribute("checked");
	},

	disable : function() {
		Element.hide(this.radioEl.parentNode);
	}

}

MobyleDBDataField = Class.create();

MobyleDBDataField.prototype = {

	initialize : function(el, dbEl, idEl, sbEl, radioEl, databox) {
		Object.extend(this, new MobyleDataboxField(el, radioEl, databox));
		this.dbEl = dbEl;
		this.idEl = idEl;
		this.sbEl = sbEl;
		this.inputType = 'db';
		var dbdf = this;
		var onDBBuilt = function() {
			// do not display this option if no databank is available...
			if (this.data.size() == 0) {
				dbdf.dbEl.hide();
				dbdf.radioEl.parentNode.hide();
			}
		};
		this.dataSelectDB = new MobyleJSONSelect(this.dbEl, this.dbFilter
				.bind(this), '#{id}', '#{label}', '#{id}', portal.banks,
				undefined, undefined, onDBBuilt);
		this.sbEl.onclick = this.checkAndGetEntry.bindAsEventListener(this);
	},

	dbFilter : function(bank) {
		if (bank.dataType == this.databox.parameterDataType) { // datatype
																// filter
		if (this.databox.parameterBioType == null || bank.bioTypes == null
				|| this.databox.parameterBioType.blank() || bank.bioTypes.blank
				&& bank.bioTypes.blank()
				|| bank.bioTypes.include(this.databox.parameterBioType)
				|| this.databox.parameterBioType.findAll
				&& this.databox.parameterBioType.findAll( function(bt) {
					if (bank.bioTypes.include(bt))
						return bt;
				}).size() > 0) {
			return true;
		}
	}
	return false;
},

checkAndGetEntry : function(evt) {
	// Element.removeClassName(this.el,'invalid_form_field');
	if (this.idEl.value != '' && this.dbEl.value != '') {
		this.getDBEntry();
	} else {
		if (this.dbEl.value == '') {
			// Element.addClassName(this.dbEl,'invalid_form_field');
			this.setInvalidFieldMessage("Invalid database.");
		}
		if (this.idEl.value == '') {
			// Element.addClassName(this.idEl,'invalid_form_field');
			this.setInvalidFieldMessage("Invalid identifier.");
		}
		return false;
	}
},

getDBEntry : function() {
	// removing previous error message (entry not found) if it exists
	this.removeInvalidFieldMessage();
	// call to golden
	var cgipars = new Object();
	cgipars.datatype = this.databox.parameterDatatype;
	cgipars.db = $F(this.dbEl);
	cgipars.id = $F(this.idEl);
	var databox = this.databox;
	new Ajax.Request('bank_get.py', {
		method :'post',
		postBody :$H(cgipars).toQueryString(),
		onLoading : function() {
			databox.valueEl.readonly = true;
		},
		onSuccess : function(transport) {
			databox.valueEl.readonly = false;
			var response = transport.responseText.evalJSON();
			// var appendFlag = $F('data_input_dbappendmode_id_' +
			// databox.databoxId);
		var firstValueEntered = !databox.valueEl.value.blank()
		databox.valueEl.value = databox.valueEl.value + response.data;
		// process replied error message from cgi
		if (!response.msg.blank()) {
			this.setInvalidFieldMessage(response.msg);
		} else {
			// Element.removeClassName(this.dbEl,'invalid_form_field');
		// Element.removeClassName(this.idEl,'invalid_form_field');
		this.removeInvalidFieldMessage();
		this.dbEl.selectedIndex = 0;
		this.idEl.value = '';
	}
}.bind(this)
	});
}

}

MobyleFileDataField = Class.create();

MobyleFileDataField.prototype = {

	initialize : function(el, radioEl, databox) {
		Object.extend(this, new MobyleDataboxField(el, radioEl, databox));
		this.uploadFileInputEl = $('data_input_upload_value_' + databox.databoxId);
		this.uploadFileFormEl = $('uploadform_' + databox.databoxId);
		this.uploadFileInputEl.onchange = this.loadFile
				.bindAsEventListener(this);
		this.uploadTargetEl = $('uploadtarget_' + databox.databoxId);
	},

	fileLoaded : function() {
		this.uploadFileInputEl.value = '';
		portal.data.build();
		this.removeInvalidFieldMessage();
		if (this.uploadTargetEl.contentDocument) {
			// W3-compatible version
			var d = this.uploadTargetEl.contentDocument;
			var txt = d.documentElement.textContent;
		} else {
			// IE-compatible version
			var d = document.frames[this.uploadTargetEl.id].document;
			var txt = d.documentElement.innerText;
		}
		this.databox.onGetData(txt);
	},

	loadFile : function() {
		var fdf = this;
		Event.observe(this.uploadTargetEl, 'load', fdf.fileLoaded
				.bindAsEventListener(fdf));
		this.uploadFileFormEl.submit();
	}

}

MobyleHistoryDataField = Class.create();

MobyleHistoryDataField.prototype = {

	initialize : function(el, userMode, databox, onBuiltFunction) {
		this.el = el;
		this.userMode = userMode;
		this.databox = databox;
		this.submitEl = $('history_' + this.userMode + '_submit_'
				+ this.databox.databoxId);
		this.onBuiltFunction = onBuiltFunction;
		this.dataSelectData = new MobyleJSONSelect(this.el,
				this.historyDataFilter.bind(this), '#{id}',
				'#{userName} first line: #{title}', '#{userName}', portal.data,
				this.submitEl, undefined, onBuiltFunction);
		this.submitEl.onclick = this.getEntry.bindAsEventListener(this);
	},

	historyDataFilter : function(historyDataItem) {
		dt = portal.datatypes.get(historyDataItem.dataType);
		if (dt && dt.ancestorTypes.include(this.databox.parameterDataType)) { // datatype
																		// filter
		if (historyDataItem.userModes.include(this.userMode)) { // user mode
																// filter
			if (this.databox.parameterBioType == null
					|| historyDataItem.bioTypes == null // biotype(s) filter
					|| this.databox.parameterBioType.blank
					&& this.databox.parameterBioType.blank()
					|| historyDataItem.bioTypes.blank
					&& historyDataItem.bioTypes.blank()
					|| this.databox.parameterBioType.size
					&& this.databox.parameterBioType.size() == 0
					|| historyDataItem.bioTypes.size
					&& historyDataItem.bioTypes.size() == 0
					|| historyDataItem.bioTypes
							.include(this.databox.parameterBioType)
					|| this.databox.parameterBioType.findAll
					&& this.databox.parameterBioType.findAll( function(bt) {
						if (historyDataItem.bioTypes.include(bt))
							return bt;
					}).size() > 0) {
				return true;
			}
		}
	}
	return false;
},

getEntry : function() {
	if ($F(this.el) != '') {
		// call to history
	var cgipars = new Object();
	cgipars.dataId = $F(this.el);
	this.el.disable();
	this.submitEl.disable();
	new Ajax.Request('data_get.py', {
		method :'post',
		postBody :$H(cgipars).toQueryString(),
		onSuccess : function(transport) {
			this.databox.onGetData(transport.responseText);
		}.bind(this),
		onComplete : function() {

			this.el.selectedIndex = 0;
			this.el.enable();
			this.submitEl.enable();

		}.bind(this)
	});
} else {
	this.databox.clear();
}
}

}

MobylePasteDataField = Class.create();

MobylePasteDataField.prototype = {

	initialize : function(el, radioEl, databox) {
		Object.extend(this, new MobyleDataboxField(el, radioEl, databox));
	}

}

MobyleResultDataField = Class.create();

MobyleResultDataField.prototype = {

	initialize : function(el, radioEl, databox) {
		Object.extend(this, new MobyleDataboxField(el, radioEl, databox));
	}

}