#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import os
import Mobyle.ConfigManager
from Mobyle.Registry import registry
from Mobyle.JobFacade import JobFacade

class Portal(mb_cgi.TALCGI):
    """
    This class defines the I{Portal} component, the uppermost component.
    @todo This is where the session should be managed
    
    @author: Catherine Letondal
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = 'portal.html'

    def process(self):
        if self.session:
            self.response['authenticated'] = self.session.isAuthenticated()
            self.response['activated'] = self.session.isActivated()
            actkey = self.request.getfirst('actkey')
            if actkey:
                self.response['actkey'] = actkey
        else:
            self.response['sessionId'] = None
            self.response['authenticated'] = False
            self.response['activated'] = False
        self.response['anonymousSession'] = (self.cfg.anonymousSession()!='no')
        self.response['authenticatedSession'] = (self.cfg.authenticatedSession()!='no')
        self.response['sessionLimit']='%.2f'%(float(self.cfg.sessionlimit())/1000)
      
        openedForms=self.request.getfirst('form')
        if openedForms:
            # here, if any pre-loaded form is requested, try to identify it by
            # its url or get its url as a local program to avoid breaking
            # external links
            formUrls = openedForms.split(',')
            self.response['openedForms'] = []
            for url in formUrls:
                if not registry.programsByUrl.has_key(url) and \
                    registry.programsByUrl.has_key(registry.getProgramUrl(url)):
                    self.response['openedForms'].append(registry.getProgramUrl(url))
                else:
                    self.response['openedForms'].append(url)
        openedJobs=self.request.getfirst('jobs')
        if openedJobs:
            jobIdsList = openedJobs.split(',')
            normalizedJobIdsList = []
            for jobId in jobIdsList:
                j = JobFacade.getFromJobId(jobId)
                status = j.getStatus()['status']
                normalizedJobIdsList.append(j.jobId)
                if not(self.session.hasJob(jobId)):
                    self.session.addJob(jobId, status = status)
            openedJobs = ','.join(normalizedJobIdsList)
            self.response['openedJobs'] = openedJobs
        annFileName = os.path.normpath(os.path.join( self.cfg.document_root(),\
                         self.cfg.htdocs_url(),"html/announcement.txt"))
        self.cssDir = os.path.normpath('/' + self.cfg.htdocs_url() + '/css')+'/'
        self.jsDir = os.path.normpath('/' + self.cfg.htdocs_url() + '/js')+'/'
        if os.path.isfile(annFileName):
            templateCacheFile = open (annFileName,'r')
            self.response['announcement'] = templateCacheFile.read()
            templateCacheFile.close()

if __name__ == "__main__":
    p = mb_cgi.SessionCGI(Portal())
    p.process()
    p.render()