#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.Registry import registry

class NetServersList(mb_cgi.JSONCGI):
    """
    This class sends the list of known Mobyle servers
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        for server in registry.servers:
            self.jsonMap[server.name] = {
                                         'url':server.url,
                                         'help':server.help,
                                         'repository':server.repository,
                                         'programs':[program.name for program in server.programs]
                                         }
        

if __name__ == "__main__":
    il = NetServersList()
    il.process()
    il.render()