#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.JobFacade import JobFacade

class JobSubmit(mb_cgi.JSONCGI):
  """
  JobSubmit is used to submit jobs from a remote mobyle portal.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
    
  def process(self):
    j = JobFacade.getFromService(self.request.getfirst('programName',None))
    j.create(self.request)
    self.result = j.submit()
    
  def render(self):
    render = self.request.getfirst("render","json")
    if render=="text":
      self.text = self.result['id']
      super(mb_cgi.JSONCGI,self).render()
    else:
      self.jsonMap = self.result
      super(JobSubmit,self).render()
                        
if __name__ == "__main__":
  try:
    js = JobSubmit()
    js.process()
    js.render()
  except Exception, e:
    import traceback, StringIO, sys
    stderrbck = sys.stderr
    sys.stderr = StringIO.StringIO()
    traceback.print_exc()
    js.c_log.error(sys.stderr.getvalue())
    sys.stderr = stderrbck
    js.c_log.error(e)