#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.JobFacade import JobFacade

class JobStatus(mb_cgi.JSONCGI):
  """
  JobStatus is used to submit jobs from a remote mobyle portal.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
    
  def process(self):
    j = JobFacade.getFromJobId(self.request.getfirst('jobId',None))
    self.result = j.getStatus()
    
  def render(self):
    render = self.request.getfirst("render","json")
    self.jsonMap = self.result
    super(JobStatus,self).render()
                        
if __name__ == "__main__":
  try:
    js = JobStatus()
    js.process()
    js.render()
  except Exception, e:
    import traceback, StringIO, sys
    stderrbck = sys.stderr
    sys.stderr = StringIO.StringIO()
    traceback.print_exc()
    js.c_log.error(sys.stderr.getvalue())
    sys.stderr = stderrbck
    js.c_log.error(e)