#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.Net
import Mobyle.MobyleError
from Mobyle.Registry import registry

class HelpRequest(mb_cgi.JSONCGI):
    """
    This class defines the I{JobSendHelpRequest} cgi
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        try:
            message = self.request.getfirst('message',None)
            responseEmailStr = self.request.getfirst('helpResponseEmail',None)
            responseEmail = Mobyle.Net.Email(responseEmailStr,self.cfg)
            jobId = self.request.getfirst('id',None)
            if jobId:
                jobServer = registry.getServerByJobId(self.request.getfirst('id',None))
            else:
                jobServer = registry.serversByName['local']
            email = Mobyle.Net.Email(jobServer.help,self.cfg)
            if self.session and self.session.getEmail():
              email.From = responseEmailStr
            from string import Template
            s = """
    User Message:
    $msg
    
    from: $responseEmail
    
    Session information:
    - id: $session_id
    - email: $session_email
    - activated?: $session_activated
    - authenticated?: $session_authenticated
    
    Job information:
    - id: $job_id
    - date: $job_date
    - status: $job_status
    - error parameter: $job_errorparam
    - error message: $job_errormsg
    """
            t = Template(s)
            body = t.substitute(session_id=self.sessionKey, 
                         session_email=self.session.getEmail(),
                         session_activated = self.session.isActivated(),
                         session_authenticated = self.session.isAuthenticated(),
                         job_id = self.request.getfirst('id',None),
                         job_date = self.request.getfirst('date',None),
                         job_status = self.request.getfirst('status',None),
                         job_errorparam = self.request.getfirst('errorparam',None),                     
                         job_errormsg = self.request.getfirst('errormsg',None),
                         msg = self.request.getfirst('message',None),
                         responseEmail = responseEmailStr
                         )
            if self.cfg.mailHelp()!=email.To:
                cc = [self.cfg.mailHelp()]
            else:
                cc=None
            email.sendMsg("[mobyle help request] help on job %s" % self.request.getfirst('id',None),body,cc)
            if responseEmail:
              try:
                responseEmail.sendMsg("[mobyle help request receipt] help on job %s" % self.request.getfirst('id',None),body)
              except:
                self.c_log.warning("failed sending help request receipt to %s" % str(self.session.getEmail()))
            
            self.jsonMap['msg_body'] = body
        except Mobyle.MobyleError.EmailError, ee:
            self.jsonMap['errormsg'] = "please provide a valid email adress"
            return
        

if __name__ == "__main__":
    hr = mb_cgi.SessionCGI(HelpRequest())
    hr.process()
    hr.render()