#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.MobyleError import UserValueError, NoSpaceLeftError
from  Mobyle.Classes.DataType import DataTypeFactory
from Mobyle.Service import MobyleType


class DataUpload(mb_cgi.JSONCGI):
    """
    This class defines the I{FileUpload} component for a databox
    This CGI is called from the databox's file tab, stores the content of the file and \
    replies either its content or its header if the contents are too big
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        if(not(self.request.has_key('data_input_upload'))):
            self.jsonMap['errormsg'] = "Please specify a file to upload."
        else:
            fileContent = self.request["data_input_upload"].file.read()
            fileName = self.request["data_input_upload"].filename
            datatype_class = self.request.getfirst('datatype_class')
            datatype_superclass = self.request.getfirst('datatype_superclass','')
            df = DataTypeFactory()
            if (datatype_superclass==''):
              dt = df.newDataType(datatype_class)
            else:
              dt = df.newDataType(datatype_superclass, datatype_class)
            mt = MobyleType(dt)
            try:
              safeFileName = self.session.addDatas( fileName , mt, content = fileContent , inputModes = ['upload'])
              contentData = self.session.getContentData(safeFileName)
            except UserValueError, e:
              self.c_log.info("UserValueError while uploading " + fileName + " - error: " +  str(e))
              self.jsonMap['errormsg'] = str(e)
            except NoSpaceLeftError, e:
              self.c_log.info("NoSpaceLeftError while uploading " + fileName + " - error: " +  str(e))
              self.jsonMap['errormsg'] = str(e)
            else:
              self.jsonMap['userName'] = fileName
              self.jsonMap['safeName'] = safeFileName
              if df.issubclass(mt.getDataType(),"Binary"):
                self.jsonMap['content'] = "Binary data..."         
              else:
                self.jsonMap['headFlag'] = contentData[0]
                if(self.jsonMap['headFlag']=="HEAD"):
                  self.jsonMap['content'] = contentData[1][0:2000]
                else:
                  self.jsonMap['content'] = contentData[1]

if __name__ == "__main__":
    du = mb_cgi.SessionCGI(DataUpload())
    du.process()
    du.render()