########################################################################################
#                                                                                      #
#   Author: Bertrand Neron,                                                            #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.        #
#                                                                                      #
########################################################################################


import smtplib
import mimetypes 
from email import Encoders
from email.Message import Message
from email.MIMEBase import MIMEBase
from email.MIMEMultipart import MIMEMultipart
from email.MIMEImage import MIMEImage
from email.MIMEText import MIMEText
import re
import os ,os.path


#import Ft.Xml 
import Ft.Xml.Domlette

#from StringIO import StringIO

from Mobyle.MobyleError import MobyleError , UserValueError , EmailError ,TooBig

##import Mobyle.ConfigManager
##_cfg = ConfigManager.Config()

import Local.black_list
import Local.Policy

import logging
n_log = logging.getLogger('mobyle.net')



class Email:
    
    INVALID = 0
    VALID = 1
    CONTINUE = 2
    COMMASPACE = ', '

    
    def __init__( self , To , cfg ):
        """
        @call: cgiJob ,  L{RunnerChild} in main
        """
        self.mobyleHelp = cfg.mailHelp()
        self.From = cfg.sender()
        if not To:
            raise MobbyleError , 'To must be a non empty string'
        self.To = To.strip()
        self.mailhost =  cfg.mailhost()
        self._methods = [ self._checkSyntax ,
                          self._checkBlackList ,
                          self._checkLocalRules ]
        
        if cfg.dnsResolver():
            self._methods.append( self._checkDns )
        
        self._message = ''
        # I disable the automatic checking because I
        # instanciate an Email objevt once in MobyleJob and an other times in
        # the main of the RunnerChild.
        # this will implied to check the adress twice.
        
        ##   chk = self._check( )
        ##   if not chk:
        ##       raise MobyleError , self._message

        
    def check( self ):
        self._message = ''

        for method in self._methods:
            rep = method()
            if rep == self.VALID :
                return True
            elif rep == self.INVALID :
                return False
            elif rep == self.CONTINUE :
                continue
            else:
                raise MobyleError , method.__name__+ " return an inavlid reponse :"+ str(rep)
        return True


    def getMessage( self ):
        return self._message
            
    def _checkSyntax( self ):
        if self.To == '' :
            self._message = "the email address is empty"
            return self.INVALID

        email_pat = re.compile( "^[a-z0-9\-\._]+\@([a-z0-9\-]+\.)+([a-z]){2,4}$" , re.IGNORECASE )
        match = re.match( email_pat , self.To )

        if match is None:
            self._message = "invalid syntax for email address"
            return self.INVALID
        else:
            return self.CONTINUE


    def _checkBlackList( self ):

        if self.To in Local.black_list.users :
            self._message = "email is in black_list"
            return self.INVALID
        else:
            return self.CONTINUE
    

    def _checkLocalRules( self ):
        #tester si le module existe ? existe toujours meme si vide ?
        import Local.Policy
        rep = Local.Policy.emailCheck( email = self.To )
        if rep == self.INVALID:
            self._message = "email is rejected by our local policy"
        return rep

    def _checkDns( self ):
        import dns.resolver
        user , domainName  = self.To.split('@')
        try:
            answers = dns.resolver.query( domainName , 'MX')
        except dns.resolver.NXDOMAIN , err :
            self._message = "unknown name domain"
            return self.INVALID
        except dns.resolver.NoAnswer ,err :
            try:
                answers = dns.resolver.query( domainName , 'A')
            except:
                self._message = "no mail server"
                return self.INVALID
            return self.CONTINUE
        except dns.name.EmptyLabel:
            self._message = "no domain name server"
            return self.INVALID
        except dns.exception.Timeout:
            self._message = "dns timeout"
            return self.INVALID
        except Exception, err:
            n_log.critical("unexpected error in  Email._checkDns : "+ str( err )  )
            return self.INVALID
        return self.CONTINUE
            

    def sendMsg( self , subject , msg , cc=None):
        msg = """%s
ps:
don't reply to this email. If you have any questions send an email to %s
        """%( msg , self.mobyleHelp )
        
        email = MIMEText( msg )
        email['Subject'] = subject
        email['From'] = self.From
        email['To'] = self.To 
        if cc: # cc is an optional list of strings
            email['Cc'] = ', '.join(cc)
        try:
            s = smtplib.SMTP( self.mailhost )
        except Exception , err:     
            #except smtplib.SMTPException , err:
            n_log.error( "can't connect to mailhost \"%s\"( check Local.Config.Config.py ): %s" %( self.mailhost , err ) )
            raise EmailError , err
        try:
            recipients = [self.To]
            if cc:
                recipients.extend(cc)
            s.sendmail( self.From ,  recipients  , email.as_string() )
            s.quit()
        except Exception , err:    
            #except smtplib.SMTPException , err:
            n_log.error("can't send email : %s" % err )
            n_log.error(recipients)
            raise EmailError , err
        


    def sendFiles( self , subject , files , msg = None ):
        """
        Send an email form from to To with the files in files attached
        @param From: the email sender
        @type From: string
        @param To: the email recips
        @type To: list of strings
        @param Subject: The email subject
        @type Subject: string
        @param files: the files which be the payload of this email
        @type files: list of strings
        """
        #jobkey = os.path.split( os.getcwd()  )[1]
        # Create the enclosing (outer) message
        outer = MIMEMultipart()
        outer['Subject'] = subject
        outer['To'] = self.To 
        outer['From'] = self.From
        outer.preamble = 'You will not see this in a MIME-aware mail reader.\n'
        # To guarantee the message ends with a newline
        outer.epilogue = ''

        if msg :
            msg = """%s
            
 ps:
 don't reply to this email. If you have any questions send an email to %s
        """%( msg , self.mobyleHelp )
            msg = MIMEText( msg )
            outer.attach( msg )

        for filename in files:

            if not os.path.isfile( filename ):
                continue
            # Guess the content type based on the file's extension.  Encoding
            # will be ignored, although we should check for simple things like
            # gzip'd or compressed files.

            ctype, encoding = mimetypes.guess_type( filename )

            if ctype is None or encoding is not None:
                # No guess could be made, or the file is encoded (compressed), so
                # use a generic bag-of-bits type.
                ctype = 'application/octet-stream'

            maintype, subtype = ctype.split( '/' , 1 )
        
            if maintype == 'text':
                fp = open( filename , 'r')
                # Note: we should handle calculating the charset
                msg = MIMEText( fp.read() , _subtype = subtype )
                fp.close()
            elif maintype == 'image':
                fp = open( filename , 'rb' )
                msg = MIMEImage( fp.read() , _subtype = subtype )
                fp.close()
            else:
                if filename == 'index.xml':
                    fp = self._indexPostProcess()
                else:
                    fp = open( filename , 'rb' )
                    
                msg = MIMEBase( maintype , subtype )
                msg.set_payload( fp.read() )
                fp.close()
                # Encode the payload using Base64
                Encoders.encode_base64( msg )

            # Set the filename parameter
            msg.add_header( 'Content-Disposition' , 'attachment', filename = os.path.basename( filename) )
            outer.attach( msg )
 
        try:
            s = smtplib.SMTP( self.mailhost )
        except Exception , err:
            n_log.error( "can't connect to mailhost \"%s\"( check Local.Config.Config.py ): %s" %( self.mailhost , err ) )
            raise MobyleError , err
        try:
            s.sendmail( self.From ,  self.To  , outer.as_string() )
            s.quit()
        except smtplib.SMTPSenderRefused, err:
            if err.smtp_code == 552 :
                raise TooBig , str( err )
            else:
                raise EmailError , err
        except smtplib.SMTPException , err:
            n_log.error("can't send email : %s" % err )
            raise EmailError , err


    def _indexPostProcess( self ):
        fh_tree = open( 'index.xml' , 'r')
        tree = ''.join( fh_tree.readlines() )
        doc = Ft.Xml.Domlette.NoExtDtdReader.parseString( tree , uri = "file://%s" %os.path.abspath(fh_tree.name) )
        
        doc = parse( 'index.xml' )
        
        old_pi = doc.childNodes[0]
        new_pi = doc.createProcessingInstruction('xml-stylesheet' ,
                                                 'href="job.xsl" type="text/xsl"')
        doc.replaceChild( new_pi , old_pi)
        fh = StringIO()
        Ft.Xml.Domlette.PrettyPrint( doc ,fh )
        fh.seek(0)
        
        return fh



def checkHost( ):

    try:
        userIP = os.environ[ 'REMOTE_ADDR' ]
    except KeyError:
        #MobyleJob is executed from commandline
        return True

    #rewriting the blacklist in a regexp
    pattern = '|'.join( Local.black_list.host )
    pattern = pattern.replace('.' , '\.' )
    pattern = pattern.replace('*' , '.*')
    pattern = "^(%s)$" % pattern
    auto = re.compile( pattern )

    if auto.search( userIP ):
        forbiddenUser = True
        msg = "IP address is in black list"
        raise UserValueError( msg = msg )
    else:
        return True
