########################################################################################
#                                                                                      #
#   Author: Bertrand Neron,                                                            #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.        #
#                                                                                      #
########################################################################################

import logging , logging.handlers
import os
import os.path

from Mobyle import ConfigManager

_cfg = ConfigManager.Config()

#===============================================================================
# memo logging level
#
# CRITICAL      50
# ERROR     40
# WARNING     30
# INFO     20
# DEBUG     10
# NOTSET     0
#===============================================================================

session_debug =True

class MLogger( object ):

    ## if we don't use the singleton pattern
    ## only one instance of logger is created
    ## but there is as much handler instance  as we call
    ## the creation procedure thus the messages are replicated

    _ref = None

    def __new__( cls , child = False):

        if cls._ref is None:
            cls._ref = super( MLogger , cls ).__new__( cls )
   
            ########################
            #                      #
            #       Formatter      # 
            #                      #
            ########################


            defaultFormatter = logging.Formatter(
                '%(name)-10s : %(levelname)-8s : %(filename)-10s: L %(lineno)d : %(asctime)s : %(message)s' ,
                '%a, %d %b %Y %H:%M:%S'
                )


            accountFormatter = logging.Formatter(
                '%(asctime)s  %(message)s' ,
                '%a, %d %b %Y %H:%M:%S')


            accessFormatter = logging.Formatter(
                '%(asctime)s %(message)s',
                 '%a, %d %b %Y %H:%M:%S' , 
                )


            builderFormatter = logging.Formatter( '%(message)s' )


            sessionFormatter = logging.Formatter(
                 'L %(lineno)d : %(asctime)s : pid = %(process)d  : %(message)s' ,
                '%a, %d %b %Y %H:%M:%S'
                )                                
            
            ########################
            #                      #
            #        Handler       #
            #                      #
            ########################

            logdir = _cfg.log_dir()
            try:

                defaultHandler = logging.FileHandler( os.path.join( logdir , 'error_log') , 'a' )
            except IOError , err :
                defaultHandler = logging.FileHandler( '/dev/null' , 'a' )
            
            #defaultHandler.setLevel(logging.WARNING)
            defaultHandler.setLevel( logging.DEBUG )
            defaultHandler.setFormatter( defaultFormatter )

            try:

                accountHandler = logging.FileHandler( os.path.join( logdir , 'account_log') , 'a' )
            except IOError , err :
                accountHandler = logging.FileHandler( '/dev/null' , 'a' )
            
            #accountHandler.setLevel()
            accountHandler.setFormatter( accountFormatter )
            
            buildLog = os.path.join( logdir , 'build_log')
            
            if not child :
                #f = open( buildLog , 'w' )
                f = open( buildLog , 'a' )
                f.close()
                
            try:          
                builderHandler = logging.FileHandler(
                    buildLog ,
                    'a' )
            except IOError , err :
                builderHandler = logging.FileHandler( '/dev/null' , 'a' )
            
            builderHandler.setLevel( logging.NOTSET )
            builderHandler.setFormatter( builderFormatter )
 
            try:
                accessHandler = logging.FileHandler( os.path.join( logdir , 'access_log')  , 'a' )
            except IOError , err :
                accessHandler = logging.FileHandler( '/dev/null' , 'a' )
           
            accessHandler.setLevel( logging.INFO )
            accessHandler.setFormatter( accessFormatter )


            mailHandler = logging.handlers.SMTPHandler( _cfg.mailhost(),
                                                        _cfg.sender() ,
                                                        _cfg.maintainer()  ,
                                                        '[ %s ] Mobyle problem' % _cfg.root_url()
                                                        )
            mailHandler.setLevel(logging.CRITICAL)


            ######################################
            try:
                infoSessionHandler = logging.FileHandler( os.path.join( logdir , 'error_log' ) , 'a' )
            except IOError , err :
                infoSessionHandler = logging.FileHandler( '/dev/null' , 'a' )
            
            #defaultHandler.setLevel(logging.WARNING)
            infoSessionHandler.setLevel( logging.INFO )
            infoSessionHandler.setFormatter( defaultFormatter )            


            try:
                if session_debug:
                    sessionHandler = logging.FileHandler( os.path.join( logdir , 'session_log') , 'a' )
                else:
                    sessionHandler = logging.FileHandler( '/dev/null' , 'a' )                                  
            except IOError , err :
                sessionHandler = logging.FileHandler( '/dev/null' , 'a' )
            
            #defaultHandler.setLevel( logging.DEBUG )
            sessionHandler.setLevel( logging.NOTSET )
            sessionHandler.setFormatter( sessionFormatter )

            #####################################




            #########################
            #                       #
            #        Logger         #
            #                       #
            #########################
            
            root = logging.getLogger()
            root.setLevel( logging.DEBUG )

            mobyle = logging.getLogger('mobyle')
            mobyle.setLevel( logging.NOTSET )
            mobyle.propagate = False
            mobyle.addHandler( defaultHandler  )

            account = logging.getLogger('mobyle.account')
            account.propagate = False
            account.addHandler( accountHandler )

            builder = logging.getLogger('mobyle.builder')
            builder.propagate = False
            builder.addHandler( builderHandler )

            access = logging.getLogger('mobyle.access')
            access.propagate = False
            access.addHandler( accessHandler )

            cgi = logging.getLogger('mobyle.cgi')
            cgi.propagate = False
            cgi.addHandler( defaultHandler )
            cgi.addHandler( mailHandler )

            registry = logging.getLogger('mobyle.registry')
            registry.propagate = False
            registry.addHandler( defaultHandler )

            tc = logging.getLogger('simpleTAL.TemplateCompiler')
            tc.propagate = False
            tc.setLevel( logging.ERROR )
            tc.addHandler( defaultHandler )
            tc.addHandler( mailHandler )

            ctc = logging.getLogger('simpleTALES.Context')
            ctc.propagate = False
            ctc.setLevel( logging.ERROR )
            ctc.addHandler( defaultHandler )
            ctc.addHandler( mailHandler )

            htc = logging.getLogger('simpleTAL.HTMLTemplateCompiler')
            htc.propagate = False
            htc.setLevel( logging.ERROR )
            htc.addHandler( defaultHandler )
            htc.addHandler( mailHandler )

            xtc = logging.getLogger('simpleTAL.XMLTemplateCompiler')
            xtc.propagate = False
            xtc.setLevel( logging.ERROR )
            xtc.addHandler( defaultHandler )
            xtc.addHandler( mailHandler )

            parser = logging.getLogger('mobyle.parser')
            parser.propagate = False
            parser.addHandler( defaultHandler )
            parser.addHandler( mailHandler )

            parser = logging.getLogger('mobyle.servicestree')
            parser.propagate = False
            parser.addHandler( defaultHandler )
            parser.addHandler( mailHandler )
            
            service = logging.getLogger('mobyle.service')
            service.propagate = False
            service.addHandler(defaultHandler  )

            pipeline = logging.getLogger('mobyle.pipeline')
            pipeline.propagate = False
            pipeline.addHandler( defaultHandler )

            evaluation = logging.getLogger('mobyle.evaluation')
            evaluation.propagate = False
            evaluation.addHandler( defaultHandler )

            mobylejob = logging.getLogger('mobyle.mobylejob')
            mobylejob.propagate = False
            mobylejob.addHandler( defaultHandler )
            mobylejob.addHandler( mailHandler )

            job = logging.getLogger('mobyle.job')
            job.propagate = False
            job.addHandler( defaultHandler )

            commandbuilder = logging.getLogger('mobyle.commandbuilder')
            commandbuilder.propagate = False
            commandbuilder.addHandler( defaultHandler )

            runnerfather = logging.getLogger('mobyle.runnerfather')
            runnerfather.propagate = False
            runnerfather.addHandler( defaultHandler )
            runnerfather.addHandler( mailHandler )

            runnerchild = logging.getLogger('mobyle.runnerchild')
            runnerchild.propagate = False
            runnerchild.addHandler( defaultHandler ) 
            runnerchild.addHandler( mailHandler )

            jobstate = logging.getLogger('mobyle.jobstate')
            jobstate.propagate = False
            jobstate.addHandler( defaultHandler )

            sequence = logging.getLogger('mobyle.converter')
            sequence.setLevel( logging.NOTSET )
            sequence.propagate = False
            sequence.addHandler( defaultHandler  )

            parameter = logging.getLogger('mobyle.parameter')
            parameter.propagate = False
            parameter.addHandler( defaultHandler )

            core = logging.getLogger('mobyle.core')
            core.propagate = False
            core.addHandler( defaultHandler )

            policy = logging.getLogger('mobyle.policy')
            policy.propagate = False
            policy.addHandler( defaultHandler )

            policy = logging.getLogger('mobyle.utils')
            policy.propagate = False
            policy.addHandler( defaultHandler )


            net = logging.getLogger('mobyle.net')
            net.propagate = False
            net.addHandler( defaultHandler )

            session = logging.getLogger('mobyle.session')
            session.propagate = False
            #session.setLevel(logging.INFO)
            #session.addHandler( defaultHandler )
            session.addHandler( infoSessionHandler )
            session.addHandler( sessionHandler )

        return cls._ref
