#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
"""
Mobyle.IndexBase
Provides mechanisms to generate, cache, and load Mobyle indexes
"""
import os
import string
import Mobyle.ConfigManager
from Mobyle.Registry import registry
from Mobyle.MobyleError import MobyleError
from Ft.Xml.Domlette import NoExtDtdReader
from Ft.Xml.Domlette import Print
from Ft.Xml.XPath import Compile, Evaluate
from Ft.Lib import UriException
import pickle

import logging
from Mobyle import MobyleLogger
MobyleLogger.MLogger()
i_log = logging.getLogger('mobyle.index' )

_cfg = Mobyle.ConfigManager.Config()

_cacheDir = _cfg.programs_cache_path()

class IndexGenerator(object):
    def __init__(self, cls):
        self.indexClass = cls
        
    def load(self):
        import sys
        input = open(self.indexClass.indexPath, 'rb')
        idx = pickle.load(input)
        input.close()
        return idx
    
    def dump(self):
        output = open(self.indexClass.indexPath, 'wb')
        idx = {}
        for program in registry.programs:
            if not program.installed:
                continue
            try:
                doc = NoExtDtdReader.parseUri(program.path)
                idx[program.url] = self.indexClass.getIndexEntry(doc)
            except:
                i_log.error("Error while generating %s entry for %s/%s" %\
                            (self.indexClass.__name__, program.server.name, \
                             program.name), exc_info=True)
        pickle.dump(idx, output, 2)
        output.close()
        
class Index(object):

    indexPath=""

    def __init__(self):
        ig =IndexGenerator(self.__class__)
        self.index = ig.load()
        
    @classmethod
    def generate(cls):
        ig =IndexGenerator(cls)
        ig.dump()
        
    @classmethod
    def getIndexEntry(cls, doc):
        raise NotImplementedError
     

def _XPathQuery(node, query, returnType="valueString"):
    """
    _XPathQuery is a helper function to get property values from the XML
    @param node: the node which is queried
    @type node: Ft.Xml.cDomlette.Element
    @param query: Compiled XPath Query
    @type query: varies
    @param returnType: the type we want returned by the function valueString|valueList|rawResult
    @type string
    """
    try:
        rawResult = Evaluate(query, node)
        if returnType == "rawResult":
            return rawResult
        valueList = [n.nodeValue for n in Evaluate(query, node) \
                     if n.nodeValue and n.nodeValue.strip()!='']
        if returnType == "valueList":
            return valueList
        valueString = ' '.join(valueList)
        if returnType == "valueString":
            return valueString
        raise Exception("unauthorized returnType value (%s), \
                        authorized values are rawResult|valueList|valueString"\
                         % valueString)
    except Exception, e:
        r_log.error(e)