#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################

"""
Mobyle.Index

This module manages the list of available programs to:
 - search them (using search fields)
 - classify them (building the categories tree)
 - cache this information (on disk as a JSON file)
"""
import os
import string
import Mobyle.ConfigManager
from Mobyle.Registry import *
from Mobyle.MobyleError import MobyleError
from Ft.Xml.Domlette import NoExtDtdReader
from Ft.Xml.Domlette import Print
from Ft.Xml.XPath import Compile, Evaluate
from Ft.Lib import UriException
import pickle

import logging
from Mobyle import MobyleLogger
from Mobyle import IndexBase
MobyleLogger.MLogger()
r_log = logging.getLogger('mobyle.index' )

_cfg = Mobyle.ConfigManager.Config()

_cacheDir = _cfg.programs_cache_path()

_indexPath = os.path.join(_cacheDir, 'inputs.dat')

queries = {
           u'title': Compile(u'/program/head/doc/description/text/text()'), 
           u'name': Compile(u'/program/head/name/text()'), 
           u'parameter': Compile(u'.//parameter'),
           u'parameter_isinput': \
           Compile(u'(not(@isout) and not(@isstdout) and not(@ishidden))'),
           u'parameter_name': Compile(u'name/text()'),
           u'parameter_prompt': Compile(u'prompt/text()'),
           u'parameter_type': Compile(u"type"),
           u'parameter_biotype': Compile(u"biotype/text()"),
           u'parameter_datatype': Compile(u"datatype"),
           u'parameter_class': Compile(u"class/text()"),
           u'parameter_superclass': Compile(u"superclass/text()"),
           u'parameter_cardinality': Compile(u"card/text()"),
          }

nifdt = [None, 
         '',
         'Boolean', 
         'Integer', 
         'Float', 
         'String', 
         'Choice', 
         'MultipleChoice', 
         'FileNameDataType', 
         'StructureDataType', 
         'PropertiesDataType']

class DataInputsIndex(IndexBase.Index):
    
    indexPath = os.path.join(_cacheDir, 'inputs.dat')
    
    def getList(self):
        inputs_list = []
        for key, entry in self.index.items():
            for item in entry:
                item.update({'id':'%s|%s' % (key, item['name'])})
                inputs_list.append(item)
        return inputs_list
    
    @classmethod
    def getIndexEntry(cls, doc):
        """
        Return an description index entry value
        @return: the index entry: value
        @rtype: object
        """
        inputParameters=[]
        programName = IndexBase._XPathQuery(doc, queries['name'])
        programTitle = IndexBase._XPathQuery(doc, queries['title'])
        pars = IndexBase._XPathQuery(doc, queries['parameter'], 'rawResult')
        for p in pars:
            parameter = {}
            parameter['isInput'] = str(IndexBase._XPathQuery(p, \
                                            queries['parameter_isinput'],\
                                            'rawResult'))
            parameter['name'] = IndexBase._XPathQuery(p, queries['parameter_name'])
            parameter['programName'] = programName
            parameter['programTitle'] = programTitle
            parameter['prompt'] = IndexBase._XPathQuery(p, queries['parameter_prompt'])
            parType = IndexBase._XPathQuery(p, \
                                  queries['parameter_type'], 
                                  'rawResult')[0]
            parameter['bioTypes'] = IndexBase._XPathQuery(parType, \
                                         queries['parameter_biotype'],"valueList")
            parDataType = IndexBase._XPathQuery(parType, \
                                      queries['parameter_datatype'],\
                                      'rawResult')[0]
            parameter['dataTypeClass'] = IndexBase._XPathQuery(parDataType, \
                                      queries['parameter_class'])
            parameter['dataTypeSuperClass'] = IndexBase._XPathQuery(parDataType, \
                                           queries['parameter_superclass'])
            card = IndexBase._XPathQuery(parType, queries['parameter_cardinality'])
            mincard = 1
            maxcard = 1
            if card != '':
                card = card.split(',')
                mincard = card[0]
                if len(card) > 1:
                    maxcard = card[1]
                else:
                    maxcard = card[0]
            parameter['minCard'] = mincard
            parameter['maxCard'] = maxcard
            #parameter['id']=program.url+'|'+parameter['name']
            for key, value in parameter.items():
                if value == '':
                    parameter[key]=None
            if parameter['isInput']=='true' and parameter['dataTypeClass'] not in nifdt:
                inputParameters.append(parameter)
        return inputParameters