#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import os
import string
import Mobyle.ConfigManager
from Mobyle.Registry import *
from Mobyle.MobyleError import MobyleError
from Ft.Xml.Domlette import NoExtDtdReader
from Ft.Xml.Domlette import Print
from Ft.Xml.XPath import Compile, Evaluate
from Ft.Lib import UriException
import pickle

import logging
from Mobyle import MobyleLogger
from Mobyle import IndexBase

MobyleLogger.MLogger()
r_log = logging.getLogger('mobyle.index' )

_cfg = Mobyle.ConfigManager.Config()

_cacheDir = _cfg.programs_cache_path()

_classificationPath = os.path.join(_cacheDir, 'classification.dat')

queries = {
           u'categories': Compile(u'/program/head/category/text()'),
          }

class ClassificationIndex(IndexBase.Index):
    
    indexPath = os.path.join(_cacheDir, 'classification.dat')

    def buildRegistryCategories(self):
        """
        Builds the categories hierarchy from
        the service definitions, using the categories information
        """
        for program in registry.programs:
            if (not(program.disabled) and (program.authorized)):
                try:
                    cats = self.index[program.url]
                    if len(cats)>0:
                        for cn in cats:# for each classification of the program
                            cs = cn.split(':')
                            path = []
                            for c in cs:
                                path.append(Mobyle.Registry.CategoryDef(name=c))
                            path.append(program)
                            program.server.addDescendant(path)
                except Exception, e:
                    r_log.error("Error while loading classification for program %s" % program.name, exc_info=True)
                    continue

    @classmethod
    def getIndexEntry(cls, doc):
        """
        Return an classification index entry value
        @return: the index entry: value
        @rtype: object
        """
        return IndexBase._XPathQuery(doc, queries['categories'], 'valueList')